% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonStartStop.r
\name{codonStartStop}
\alias{codonStartStop}
\title{Identify all potential start and stop codons in a nucleotide sequence}
\usage{
codonStartStop(x)
}
\arguments{
\item{x}{character string giving the nucleotide sequence.}
}
\value{
list of potential start and stop codons with their coordinates.
}
\description{
This function scans a nucleotide sequence of interest
    in the search of canonical start codon ATG or non-canonical start
    codons GTG, TTG and CTG as well as stop codons TAA, TAG and TGA.
}
\examples{
codons <- codonStartStop(x = "AAAATGGCATGGTAAGTC")
}
\author{
Vasily V. Grinev
}
