% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normMethods.R
\name{normMethods}
\alias{normMethods}
\title{Perform normalizations on Normalyzer dataset}
\usage{
normMethods(
  nds,
  forceAll = FALSE,
  normalizeRetentionTime = TRUE,
  quiet = FALSE,
  rtStepSizeMinutes = 1,
  rtWindowMinCount = 100,
  rtWindowShifts = 1,
  rtWindowMergeMethod = "mean",
  noLogTransform = FALSE
)
}
\arguments{
\item{nds}{Normalyzer dataset object.}

\item{forceAll}{Force all methods to run despite not qualifying for thresholds.}

\item{normalizeRetentionTime}{Perform retention time based normalization methods.}

\item{quiet}{Prevent diagnostic output}

\item{rtStepSizeMinutes}{Retention time normalization window size.}

\item{rtWindowMinCount}{Minimum number of datapoints in each retention-time
segment.}

\item{rtWindowShifts}{Number of layered retention time normalized windows.}

\item{rtWindowMergeMethod}{Merge approach for layered retention time windows.}

\item{noLogTransform}{Per default NormalyzerDE performs a log-transformation
on the input data. If not needed, specify this option}
}
\value{
Returns Normalyzer results object with performed analyzes assigned
 as attributes
}
\description{
Perform normalizations on Normalyzer dataset
}
\examples{
data(example_summarized_experiment)
normObj <- getVerifiedNormalyzerObject("job_name", example_summarized_experiment)
normResults <- normMethods(normObj)
}
