% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.R
\name{pathwayEnrichment}
\alias{pathwayEnrichment}
\title{For a given gmt file of a specific pathway database, pathway enrichment
can be performed. Function supports Entrez ID and symbol based gmt file.}
\usage{
pathwayEnrichment(
  genes,
  gmtFile,
  org_assembly = c("hg19", "hg38", "mm10", "dre10", "rn6", "dm6", "ce11", "sc3"),
  pCut = 0.05,
  pAdjCut = 0.05,
  pAdjust = c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"),
  isSymbol,
  min = 5,
  isGeneEnrich = FALSE
)
}
\arguments{
\item{genes}{Input genes}

\item{gmtFile}{File path of the gmt file}

\item{org_assembly}{Genome assembly of interest for the analysis. Possible
assemblies are "mm10" for mouse, "dre10" for zebrafish, "rn6" for rat,
"dm6" for fruit fly, "ce11" for worm, "sc3" for yeast, "hg19" and
"hg38" for human}

\item{pCut}{Threshold value for the pvalue. Default value is 0.05}

\item{pAdjCut}{Cutoff value for the adjusted p-values using one of given
method. Default value is 0.05.}

\item{pAdjust}{Methods of the adjusted p-values. Possible methods are
"holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none"}

\item{isSymbol}{Boolean value that controls the gene formats. If it is TRUE,
gene format of the gmt file should be symbol. Otherwise, gene format
must be ENTREZ ID.}

\item{min}{Minimum number of genes that are required for enrichment. By
default, it is set to 5.}

\item{isGeneEnrich}{Boolean value whether gene enrichment should be
performed}
}
\value{
Pathway Enrichment
}
\description{
For a given gmt file of a specific pathway database, pathway enrichment
can be performed. Function supports Entrez ID and symbol based gmt file.
}
