% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLimmaAnalysis.R
\name{runLimmaAnalysis}
\alias{runLimmaAnalysis}
\title{Conduct differential expression analysis}
\usage{
runLimmaAnalysis(
  dat,
  groups = NULL,
  base.group = NULL,
  design = NULL,
  codeclass.retain = "endogenous",
  ...
)
}
\arguments{
\item{dat}{NanoString data ExpressionSet, from processNanostringData}

\item{groups}{character vector, in same order as the samples in dat. NULL
if already included in 'dat'}

\item{base.group}{the group against which other groups are compared (must
be one of the levels in 'groups'). Will use the first group if NULL.}

\item{design}{a design matrix for Limma analysis (default NULL, will do 
analysis based on provided 'group' data)}

\item{codeclass.retain}{The CodeClasses to retain for Limma analysis. 
Generally we're interested in endogenous genes, so we keep "endogenous" 
only by default. Others can be included by entering a character vector for 
this option (see limmaResults3 example). Alternatively, all targets can be 
retained by setting this option to ".".}

\item{...}{Optional arguments to be passed to limma::lmFit}
}
\value{
The fit Limma object
}
\description{
Use Limma to conduct a simple differential expression analysis. All groups 
are compared against the base.group, and empirical Bayes method is used to
identify significantly differentially expressed genes. Alternatively, a
design matrix can be supplied, as explained in limma::limmaUsersGuide()
}
\examples{
example_data <- system.file("extdata", "GSE117751_RAW", package = "NanoTube")
sample_info <- system.file("extdata", "GSE117751_sample_data.csv", 
                           package = "NanoTube")

dat <- processNanostringData(nsFiles = example_data,
                             sampleTab = sample_info, 
                             groupCol = "Sample_Diagnosis")

# Compare the two diseases against healthy controls ("None")
limmaResults <- runLimmaAnalysis(dat, base.group = "None")


# You can also supply a design matrix
# Generate fake batch labels
batch <- rep(c(0, 1), times = ncol(dat) / 2)

# Reorder groups ("None" first)
group <- factor(dat$groups, levels = c("None", "Autoimmune retinopathy", 
                                       "Retinitis pigmentosa"))

# Design matrix including sample group and batch
design <- model.matrix(~group + batch)

# Analyze data
limmaResults2 <- runLimmaAnalysis(dat, design = design)

# Run Limma analysis including endogenous *and* housekeeping genes.
limmaResults3 <- runLimmaAnalysis(dat, design = design,
                     codeclass.retain = c("endogenous", "housekeeping"))
}
