% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genome_builds.R
\name{get_genome_builds}
\alias{get_genome_builds}
\title{Infer genome builds}
\usage{
get_genome_builds(
  sumstats_list,
  header_only = TRUE,
  sampled_snps = 10000,
  names_from_paths = FALSE,
  dbSNP = 155,
  dbSNP_tarball = NULL,
  nThread = 1,
  chr_filt = NULL
)
}
\arguments{
\item{sumstats_list}{A named list of paths to summary statistics,
or a named list of \code{data.table} objects.}

\item{header_only}{Instead of reading in the entire \code{sumstats} file,
only read in the first N rows where N=\code{sampled_snps}.
This should help speed up cases where you have to read in \code{sumstats}
from disk each time.}

\item{sampled_snps}{Downsample the number of SNPs used when inferring genome
build to save time.}

\item{names_from_paths}{Infer the name of each item in \code{sumstats_list}
from its respective file path.
Only works if \code{sumstats_list} is a list of paths.}

\item{dbSNP}{version of dbSNP to be used (144 or 155). Default is 155.}

\item{dbSNP_tarball}{Pass local versions of dbSNP in tarball format. Default
of NULL uses the dbSNP version passed in \code{dbSNP} parmeter. \code{dbSNP_tarball}
was enabled to help with dbSNP versions >=156, after the decision to no
longer provide dbSNP releases as bioconductor packages. dbSNP 156 tarball is
available here: http://149.165.171.124/SNPlocs/.}

\item{nThread}{Number of threads to use for parallel processes.}

\item{chr_filt}{Internal for testing - filter reference genomes and sumstats
to specific chromosomes for testing. Pass a list of chroms in format:
c("1","2"). Default is NULL i.e. no filtering}
}
\value{
ref_genome the genome build of the data
}
\description{
Infers the genome build of  summary statistics files (GRCh37 or GRCh38)
from the data. Uses SNP (RSID) & CHR & BP to get genome build.
}
\details{
Iterative version of \code{get_genome_build}.
}
\examples{
# Pass path to Educational Attainment Okbay sumstat file to a temp directory

eduAttainOkbayPth <- system.file("extdata", "eduAttainOkbay.txt",
    package = "MungeSumstats"
)
sumstats_list <- list(ss1 = eduAttainOkbayPth, ss2 = eduAttainOkbayPth)

## Call uses reference genome as default with more than 2GB of memory,
## which is more than what 32-bit Windows can handle so remove certain checks
is_32bit_windows <-
    .Platform$OS.type == "windows" && .Platform$r_arch == "i386"
if (!is_32bit_windows) {
    
    #multiple sumstats can be passed at once to get all their genome builds:
    #ref_genomes <- get_genome_builds(sumstats_list = sumstats_list)
    #just passing first here for speed
    sumstats_list_quick <- list(ss1 = eduAttainOkbayPth)
    ref_genomes <- get_genome_builds(sumstats_list = sumstats_list_quick,
                                     dbSNP=144)
}
}
