% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_coords.R
\name{sort_coords}
\alias{sort_coords}
\title{Sort sum stats}
\usage{
sort_coords(
  sumstats_dt,
  sort_coordinates = TRUE,
  sort_method = c("data.table", "GenomicRanges")
)
}
\arguments{
\item{sumstats_dt}{\link[data.table]{data.table} obj of the
summary statistics file for the GWAS.}

\item{sort_method}{Method to sort coordinates by:
\itemize{
\item{"data.table" (default)}{Uses \link[data.table]{setorderv},
which is must faster than "GenomicRanges"
but less robust to variations in some sum stats files.}
\item{"GenomicRanges"}{Uses \link[GenomicRanges]{sort.GenomicRanges},
which is more robust to variations in sum stats files
but much slower than the "data.table" method.}
}}

\item{sort_coords}{Whether to sort by coordinates.}
}
\value{
Sorted sumstats_dt
}
\description{
Sort summary statistics table by genomic coordinates.
}
\keyword{internal}
