% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dup_snp.R
\name{check_dup_snp}
\alias{check_dup_snp}
\title{Ensure all rows have unique SNP IDs, drop those that don't}
\usage{
check_dup_snp(
  sumstats_dt,
  indels,
  path,
  log_folder_ind,
  check_save_out,
  tabix_index,
  nThread,
  log_files,
  bi_allelic_filter,
  check_dups
)
}
\arguments{
\item{indels}{Binary does your Sumstats file contain Indels? These don't
exist in our reference file so they will be excluded from checks if this
value is TRUE. Default is TRUE.}

\item{path}{Filepath for the summary statistics file to be formatted. A
dataframe or datatable of the summary statistics file can also be passed
directly to MungeSumstats using the path parameter.}

\item{log_folder_ind}{Binary Should log files be stored containing all
filtered out SNPs (separate file per filter). The data is outputted in the
same format specified for the resulting sumstats file. The only exception to
this rule is if output is vcf, then log file saved as .tsv.gz. Default is
FALSE.}

\item{tabix_index}{Index the formatted summary statistics with
\href{http://www.htslib.org/doc/tabix.html}{tabix} for fast querying.}

\item{nThread}{Number of threads to use for parallel processes.}

\item{log_files}{list of log file locations}

\item{bi_allelic_filter}{Binary Should non-bi-allelic SNPs be removed.
Default is TRUE.}

\item{check_dups}{whether to check for duplicates - if formatting QTL
datasets this should be set to FALSE otherwise keep as TRUE. Default is TRUE.}
}
\value{
list containing sumstats_dt, the modified summary statistics data
table object and log files list
}
\description{
Ensure all rows have unique SNP IDs, drop those that don't
}
\keyword{internal}
