% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name-methods.R
\name{name-methods}
\alias{name-methods}
\alias{names,MultimodalExperiment-method}
\alias{names}
\alias{names<-,MultimodalExperiment-method}
\alias{names<-}
\alias{rownames,MultimodalExperiment-method}
\alias{rownames}
\alias{rownames<-,MultimodalExperiment-method}
\alias{rownames<-}
\alias{colnames,MultimodalExperiment-method}
\alias{colnames}
\alias{colnames<-,MultimodalExperiment,ANY-method}
\alias{colnames<-}
\alias{dimnames,MultimodalExperiment-method}
\alias{dimnames}
\alias{dimnames<-,MultimodalExperiment,ANY-method}
\alias{dimnames<-}
\alias{experimentNames,MultimodalExperiment-method}
\alias{experimentNames}
\alias{experimentNames<-,MultimodalExperiment-method}
\alias{experimentNames<-}
\title{MultimodalExperiment Name Methods}
\usage{
\S4method{names}{MultimodalExperiment}(x)

\S4method{names}{MultimodalExperiment}(x) <- value

\S4method{rownames}{MultimodalExperiment}(x)

\S4method{rownames}{MultimodalExperiment}(x) <- value

\S4method{colnames}{MultimodalExperiment}(x)

\S4method{colnames}{MultimodalExperiment,ANY}(x) <- value

\S4method{dimnames}{MultimodalExperiment}(x)

\S4method{dimnames}{MultimodalExperiment,ANY}(x) <- value

\S4method{experimentNames}{MultimodalExperiment}(x)

\S4method{experimentNames}{MultimodalExperiment}(x) <- value
}
\arguments{
\item{x}{a \linkS4class{MultimodalExperiment} object}

\item{value}{a replacement value}
}
\value{
\code{names} returns a \link[IRanges:AtomicList-class]{CharacterList} object.

\code{rownames} returns a \link[IRanges:AtomicList-class]{CharacterList} object.

\code{colnames} returns a \link[IRanges:AtomicList-class]{CharacterList} object.

\code{dimnames} returns a \link[base:list]{list} object.

\code{experimentNames} returns a \link[base:character]{character} vector.
}
\description{
Extract or replace names of a \linkS4class{MultimodalExperiment} object.
}
\examples{
ME <-
    MultimodalExperiment()

bulkExperiments(ME) <-
    ExperimentList(
        pbRNAseq = pbRNAseq
    )

singleCellExperiments(ME) <-
    ExperimentList(
        scADTseq = scADTseq,
        scRNAseq = scRNAseq
    )

subjectMap(ME)[["subject"]] <-
    "SUBJECT-1"

sampleMap(ME)[["subject"]] <-
    "SUBJECT-1"

cellMap(ME)[["sample"]] <-
    "SAMPLE-1"

ME <-
    propagate(ME)

experimentData(ME)[["published"]] <-
    c(NA_character_, "2018-11-19", "2018-11-19") |>
    as.Date()

subjectData(ME)[["condition"]] <-
    as.character("healthy")

sampleData(ME)[["sampleType"]] <-
    as.character("peripheral blood mononuclear cells")

cellType <- function(x) {
    if (x[["CD4"]] > 0L) {
        return("T Cell")
    }

    if (x[["CD14"]] > 0L) {
        return("Monocyte")
    }

    if (x[["CD19"]] > 0L) {
        return("B Cell")
    }

    if (x[["CD56"]] > 0L) {
        return("NK Cell")
    }

    NA_character_
}

cellData(ME)[["cellType"]] <-
    experiment(ME, "scADTseq") |>
    apply(2L, cellType)

names(ME) <-
    names(ME) |>
    tolower()

names(ME)

rownames(ME) <-
    rownames(ME) |>
    toupper()

rownames(ME)

colnames(ME) <-
    colnames(ME) |>
    tolower()

colnames(ME)

dimnames(ME)[[2L]] <-
    dimnames(ME)[[2L]] |>
    toupper()

dimnames(ME)[[2L]]

experimentNames(ME) <-
    experimentNames(ME) |>
    gsub(pattern = "seq", replacement = "-seq")

experimentNames(ME)

}
\seealso{
\code{browseVignettes("MultimodalExperiment")}
}
