% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example-data.R
\docType{data}
\name{example-data}
\alias{example-data}
\alias{pbRNAseq}
\alias{scADTseq}
\alias{scRNAseq}
\title{MultimodalExperiment Example Data}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 3000 rows and 1 columns.

An object of class \code{matrix} (inherits from \code{array}) with 8 rows and 5000 columns.

An object of class \code{matrix} (inherits from \code{array}) with 3000 rows and 5000 columns.
}
\source{
\emph{PBMCs of a Healthy Donor - 5' Gene Expression with a Panel of
TotalSeq™-C Antibodies}, Single Cell Immune Profiling Dataset by Cell Ranger
3.0.0, 10x Genomics, (2018, November 19).
}
\usage{
pbRNAseq

scADTseq

scRNAseq
}
\description{
Human peripheral blood mononuclear cells (PBMCs) from a single healthy donor
were profiled by cellular indexing of transcriptomes and epitopes by
sequencing (CITE-seq) to generate single-cell antibody-derived tag sequencing
(\code{scADTseq}) and single-cell RNA sequencing (\code{scRNAseq}) data simultaneously;
the \code{scRNAseq} data was summed into pseudo-bulk RNA sequencing (\code{pbRNAseq})
data. The dimensions of resulting matrices were reduced to conserve storage
because these data are only used to demonstrate the functionality of the
\linkS4class{MultimodalExperiment} class.
}
\examples{
pbRNAseq[1:4, 1:1, drop = FALSE]

scADTseq[1:4, 1:4, drop = FALSE]

scRNAseq[1:4, 1:4, drop = FALSE]

}
\keyword{datasets}
