% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultimodalExperiment-class.R
\docType{class}
\name{MultimodalExperiment-class}
\alias{MultimodalExperiment-class}
\title{MultimodalExperiment Class Definition}
\description{
MultimodalExperiment is an S4 class that integrates bulk and single-cell
experiment data; it is optimally storage-efficient, and its methods are
exceptionally fast. It effortlessly represents multimodal data of any nature
and features normalized experiment, subject, sample, and cell annotations,
which are related to underlying biological experiments through maps. Its
coordination methods are opt-in and employ database-like join operations
internally to deliver fast and flexible management of multimodal data.
}
\details{
The term matrix-like objects refers to \link[base:matrix]{matrix}
objects or Bioconductor S4 objects that contain them (
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment},
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment},
etc.) where rows represent features and columns represent observations.
}
\section{Slots}{

\describe{
\item{\code{experimentData}}{a \link[S4Vectors:DataFrame-class]{DataFrame} of experiment
annotations with experiment indices as rownames}

\item{\code{subjectData}}{a \link[S4Vectors:DataFrame-class]{DataFrame} of subject
annotations with subject indices as rownames}

\item{\code{sampleData}}{a \link[S4Vectors:DataFrame-class]{DataFrame} of sample
annotations with sample indices as rownames}

\item{\code{cellData}}{a \link[S4Vectors:DataFrame-class]{DataFrame} of cell annotations
with cell indices as rownames}

\item{\code{experimentMap}}{a \link[S4Vectors:DataFrame-class]{DataFrame} of type (bulk
or single-cell) to experiment (index) mappings}

\item{\code{subjectMap}}{a \link[S4Vectors:DataFrame-class]{DataFrame} of experiment
(index) to subject (index) mappings}

\item{\code{sampleMap}}{a \link[S4Vectors:DataFrame-class]{DataFrame} of subject (index)
to sample (index) mappings}

\item{\code{cellMap}}{a \link[S4Vectors:DataFrame-class]{DataFrame} of sample (index) to
cell (index) mappings}

\item{\code{experiments}}{an \link{ExperimentList} of matrix-like objects}

\item{\code{metadata}}{a \link[base:list]{list} of metadata objects}
}}

\seealso{
\code{browseVignettes("MultimodalExperiment")}
}
