% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAgraphics.R
\name{PCAgraphics}
\alias{PCAgraphics}
\title{Multiple 2D and 3D PCA graphs.}
\usage{
PCAgraphics(
  SEresNorm,
  DATAnorm = TRUE,
  gene.deletion = NULL,
  sample.deletion = NULL,
  Plot.PCA = TRUE,
  Mean.Accross.Time = FALSE,
  Color.Group = NULL,
  motion3D = FALSE,
  Phi = 25,
  Theta = 140,
  epsilon = 0.2,
  Cex.point = 0.7,
  Cex.label = 0.7,
  path.result = NULL,
  Name.file.pca = NULL
)
}
\arguments{
\item{SEresNorm}{Results of the function
\code{\link[=DATAnormalization]{DATAnormalization()}}.}

\item{DATAnorm}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
\code{TRUE} means the function uses the normalized data.
\code{FALSE} means the function uses the raw counts data.}

\item{gene.deletion}{\code{NULL} or a vector of characters or a vector of
integers. \code{NULL} as default.
If \code{gene.deletion} is a vector of characters, all genes with names in
\code{gene.deletion} will be deleted from the data set as input
\code{RawCounts} of our function
\code{\link[=DATAprepSE]{DATAprepSE()}}.
If \code{gene.deletion} is a vector of integers,
all the corresponding row numbers will be deleted from the data set as input
\code{RawCounts} of our function
\code{\link[=DATAprepSE]{DATAprepSE()}}.
If \code{gene.deletion=NULL} all genes will be used in the construction
of the PCA.}

\item{sample.deletion}{\code{NULL} or a vector of characters or
a vector of integers. \code{NULL} as default.
If \code{sample.deletion} is a vector of characters, all samples with names
in \code{sample.deletion} will not be used in the construction of the PCA.
If \code{sample.deletion} is a vector of integers,
all the corresponding column numbers will not be used in the construction
of the PCA from the data set as input \code{RawCounts} of our function
\code{\link[=DATAprepSE]{DATAprepSE()}}.
If \code{sample.deletion=NULL} all samples will be used
in the construction of the PCA.}

\item{Plot.PCA}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, PCA graphs will be plotted.
Otherwise no graph will be plotted.}

\item{Mean.Accross.Time}{\code{TRUE} or \code{FALSE}.
\code{FALSE} as default.
If \code{FALSE} and if \code{Time.position}
(input of \code{\link[=DATAprepSE]{DATAprepSE()}})
is not set as \code{NULL}, consecutive time points within a sample
are linked to help visualization of temporal patterns.
If \code{TRUE} and if \code{Time.position} is not set as \code{NULL},
the mean per time of all genes is computed for each biological condition and
the means of consecutive time points within biological condition are
linked to help visualization of temporal patterns.}

\item{Color.Group}{\code{NULL} or a data.frame with \eqn{N_{bc}} rows and
two columns where \eqn{N_{bc}} is the number of biological conditions.
If \code{Color.Group}
(input of \code{\link[=DATAprepSE]{DATAprepSE()}})
is a data.frame, the first column must contain
the name of each biological condition and the second column must contain
the colors associated to each biological condition.
If \code{Color.Group=NULL}, the function will automatically attribute
a color for each biological condition.
If samples belong to different time points only,
\code{Color.Group} will not be used.}

\item{motion3D}{\code{TRUE} or \code{FALSE}.
If TRUE, the 3D PCA plots will also be plotted in a rgl window
(see \code{\link[plot3Drgl:plotrgl]{plot3Drgl::plotrgl()}})
allowing to interactively rotate and zoom.}

\item{Phi}{Angle defining the colatitude direction for the 3D PCA plot
(see \code{Details} in
\code{\link[graphics:persp]{graphics::persp()}}).}

\item{Theta}{Angle defining the azimuthal direction for the 3D PCA plot
(see \code{Details} in
\code{\link[graphics:persp]{graphics::persp()}}).}

\item{epsilon}{Non negative numeric value giving the length between points
and their labels in all PCA plots which are not automatically plotted
by \code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}.}

\item{Cex.point}{Non negative numeric value giving the size of points
in all PCA plots which are not automatically plotted by
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}.}

\item{Cex.label}{Non negative numeric value giving the size of
the labels associated to each point of the all PCA graphs
which are not automatically plotted by
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}.}

\item{path.result}{Character or \code{NULL}.
Path to save the different PCA graphs.
If \code{NULL}, the different PCA graphs will not be saved in a folder.
\code{NULL} as default.}

\item{Name.file.pca}{Character or \code{NULL}.
If \code{Name.file.pca} is a character, \code{Name.file.pca} will be added
at the beginning of all names of the saved graphs.}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEresNorm} with the outputs from the function
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}},
and plots several 2D and 3D PCA graphs depending
on the experimental design (if \code{Plot.PCA=TRUE}),
saved in the metadata \code{Results[[1]][[2]]} of \code{SEresNorm},
\itemize{
\item When samples belong only to different biological conditions,
the function returns a 2D and two 3D PCA graphs.
In each graph, samples are colored with different colors for different
biological conditions. The two 3D PCA graphs are identical but
one of them will be opened in a rgl window
(see \code{\link[plot3Drgl:plotrgl]{plot3Drgl::plotrgl()}})
and it allows to interactively rotate and zoom.
\item When samples belong only to different time points, the function returns
\itemize{
\item One 2D PCA graph, one 3D PCA graph and the same 3D PCA graph
in a rgl window where samples are colored with different colors
for different time points.
Furthermore, lines are drawn between each pair of consecutive points
for each sample (if \code{Mean.Accross.Time=FALSE},
otherwise it will be only between means).
\item The same graphs describe above but without lines.
}
\item When samples belong to different time points and different
biological conditions, the function returns
\itemize{
\item One 2D PCA graph, one 3D PCA graph and the same 3D PCA graph
in a rgl window where samples are colored with different colors
for different time points.
Furthermore, lines are drawn between each pair of consecutive points
for each sample (if \code{Mean.Accross.Time=FALSE},
otherwise it will be only between means).
\item The same graphs describe above but without lines.
\item The same six following graphs for each biological condition
(one PCA analysis per biological condition).
One 2D PCA graph, one 3D PCA graph and the same 3D PCA graph
in a rgl window where samples belong to only one biological condition
and are colored with different colors for different time points.
Furthermore, lines are drawn between each pair of consecutive points
for each sample (if \code{Mean.Accross.Time=FALSE},
otherwise it will be only between means).
The three others graphs are identical to the three previous ones
but without lines.
}
}

The interactive 3D graphs will be plotted only if \code{motion3D=TRUE}.
}
\description{
The function plots 2D and 3D PCA using the function
\code{\link[=PCArealization]{PCArealization()}}
which realizes a PCA analysis. This function is called repeatedly by the
function \code{\link[=PCAanalysis]{PCAanalysis()}}
if samples belong to different biological conditions and time points.
}
\details{
All results are built from the results of our function
\code{\link[=DATAnormalization]{DATAnormalization()}}.
}
\examples{
## Simulation raw counts
resSIMcount <- RawCountsSimulation(Nb.Group=2, Nb.Time=3, Nb.per.GT=4,
                                   Nb.Gene=10)
## Preprocessing step
resDATAprepSE <- DATAprepSE(RawCounts=resSIMcount$Sim.dat,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=2,
                            Individual.position=3)
## Normalization
resNorm <- DATAnormalization(SEres=resDATAprepSE,
                             Normalization="rle",
                             Plot.Boxplot=FALSE,
                             Colored.By.Factors=FALSE)
## Color for each group
GROUPcolor <- data.frame(Name=c("G1", "G2"), Col=c("black", "red"))
##------------------------------------------------------------------------##
resPCAgraph <- PCAgraphics(SEresNorm=resNorm,
                           DATAnorm=TRUE,
                           gene.deletion=c("Gene1", "Gene5"),
                           sample.deletion=c(2,6),
                           Plot.PCA=TRUE,
                           Mean.Accross.Time=FALSE,
                           Color.Group=GROUPcolor,
                           motion3D=FALSE,
                           Phi=25, Theta=140, Cex.label=0.7,
                           Cex.point=0.7, epsilon=0.2,
                           path.result=NULL, Name.file.pca=NULL)
}
\seealso{
This function is called by our function
\code{\link[=PCAanalysis]{PCAanalysis()}}
and calls our function
\code{\link[=PCArealization]{PCArealization()}}.
}
