% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{add_rnaseq}
\alias{add_rnaseq}
\title{Method to add an expression RNA seq dataset to \code{MultiDataSet}.}
\usage{
add_rnaseq(object, rnaSet, ...)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filled.}

\item{rnaSet}{\code{ExpressionSet} to be used to fill the slot.}

\item{...}{Arguments to be passed to \code{add_eset}.}
}
\value{
A new \code{MultiDataSet} with the slot \code{"rnaseq"}
filled.
}
\description{
This method adds or overwrites the slot \code{"rnaseq"} of an
\code{MultiDataSet} with the content of the given \code{ExpressionSet}. The fData of 
the \code{ExpressionSet} must contain the columns chromosome, start and end.
}
\examples{
multi <- createMultiDataSet()
eset <- new("ExpressionSet", exprs = matrix(runif(4), 2))
fData(eset) <- data.frame(chromosome = c("chr1", "chr2"), start = c(12414, 1234321),
 end = c(121241, 12122414), stringsAsFactors = FALSE)
multi <- add_genexp(multi, eset)
}
