% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_h5mu.R
\name{readH5MU}
\alias{readH5MU}
\title{Read an .h5mu file and create a \code{\link{MultiAssayExperiment}}.}
\usage{
readH5MU(file, backed = FALSE)
}
\arguments{
\item{file}{Path to the .h5mu file.}

\item{backed}{Whether to use file-backed mode.}
}
\value{
A \code{\linkS4class{MultiAssayExperiment}}
}
\description{
In file-backed mode, the main \code{X} matrices are not read into memory,
but reference the HDF5 file and their required parts are read on demand.
This requires the HDF5Array package to be installed.
}
\examples{
data(miniACC, package="MultiAssayExperiment")
writeH5MU(miniACC, "miniacc.h5mu")
mae <- readH5MU("miniacc.h5mu")

}
