% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{rtOverMsQuarters}
\alias{rtOverMsQuarters}
\title{MS1 quarter RT fraction (MS:4000055) or 
MS2 quarter RT fraction (MS:4000056)}
\usage{
rtOverMsQuarters(spectra, msLevel = 1L, ...)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{msLevel}{\code{integer}}

\item{...}{not used here}
}
\value{
\code{numeric(4)}
}
\description{
MS:4000055 \cr
"The interval used for acquisition of the first, second, third, and fourth 
quarter of all MS1 events divided by retention time duration." [PSI:MS] \cr

MS:4000056 \cr
"The interval used for acquisition of the first, second, third, and fourth 
quarter of all MS2 events divided by retention time duration." [PSI:MS] \cr

The metric is calculated as follows: \cr
(1) the retention time duration of the whole \code{Spectra} object is determined
(taking into account all the MS levels), \cr 
(2) the \code{Spectra} object is filtered according to the MS level and 
subsequently ordered according to the retention time \cr 
(3) the MS events are split into four (approximately) equal parts, \cr 
(4) the relative retention time is calculated (using the retention time 
duration from (1) and taking into account the minimum retention time), \cr 
(5) the relative retention time values associated to the MS event parts
are returned.
}
\details{
MS:4000055 \cr
synonym: "RT-MS-Q1" RELATED [PMID:24494671] \cr
synonym: "RT-MS-Q2" RELATED [PMID:24494671] \cr
synonym: "RT-MS-Q3" RELATED [PMID:24494671] \cr
synonym: "RT-MS-Q4" RELATED [PMID:24494671] \cr
is_a: MS:4000004 ! n-tuple \cr 
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000016 ! retention time metric \cr
relationship: has_metric_category MS:4000021 ! MS1 metric \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV term \cr
relationship: has_units UO:0000191 ! fraction \cr

MS:4000056 \cr
synonym: "RT-MSMS-Q1" RELATED [PMID:24494671] \cr
synonym: "RT-MSMS-Q2" RELATED [PMID:24494671] \cr
synonym: "RT-MSMS-Q3" RELATED [PMID:24494671] \cr
synonym: "RT-MSMS-Q4" RELATED [PMID:24494671] \cr
is_a: MS:4000004 ! n-tuple \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000016 ! retention time metric \cr
relationship: has_metric_category MS:4000022 ! MS2 metric \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV term \cr
relationship: has_units UO:0000191 ! fraction \cr

The function returns \code{c(NaN, NaN, NaN, NaN)} if the filtered 
\code{spectra} object has less than 4 scan events.

An attribute containing the PSI:MS term will only be returned if 
\code{msLevel} is 1 or 2.
}
\note{
\code{chromatographyDuration} considers the total runtime (including MS1 
and MS2 scans).
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L, 2L),
    polarity = c(1L, 1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847", "unknown"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine", "unknown"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876),
    c(83.0603, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994),
    c(3.146, 61.611))
spd$rtime <- c(9.44, 9.44, 15.84, 15.81)
sps <- Spectra(spd)
rtOverMsQuarters(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake, Johannes Rainer
}
