% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{ratioCharge1over2}
\alias{ratioCharge1over2}
\title{ratio of 1+ over 2+ of all MS2 known precursor charges
(MS:4000167) or ratio of 1+ over 2+ of identified MS2 known precursor charges
(MS:4000168)}
\usage{
ratioCharge1over2(
  spectra,
  msLevel = 1L,
  identificationLevel = c("all", "identified", "unidentified"),
  ...
)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{msLevel}{\code{integer}}

\item{identificationLevel}{\code{character(1)}, one of \code{"all"}, 
\code{"identified"}, or \code{"unidentified"}}

\item{...}{not used here}
}
\value{
\code{numeric(1)}
}
\description{
MS:4000167 \cr
"The ratio of 1+ over 2+ MS2 precursor charge count of all spectra. High 
ratios of 1+/2+ MS2 precursor charge count may indicate inefficient 
ionization." [PSI:MS] \cr

MS:4000168 \cr
"The ratio of 1+ over 2+ MS2 precursor charge count of identified spectra. 
High ratios of 1+/2+ MS2 precursor charge count may indicate inefficient 
ionization. The used type of identification should be noted in the metadata 
or analysis methods section of the recording file for the respective run. 
In case of multiple acceptance criteria (FDR) available in proteomics, 
PSM-level FDR should be used for better comparability." [PSI:MS] \cr

The metric is calculated as follows: \cr
(1) the \code{Spectra} object is filtered according to the MS level, \cr 
(2) the precursor charge is obtained, \cr 
(3) the number of precursors with charge 1+ is divided by the number of 
precursors with charge 2+ and the ratio is returned. \cr
}
\details{
MS:4000167 \cr
is_a: MS:4000001 ! QC metric \cr
is_a: MS:4000003 ! single value \cr
is_a: MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000020 ! ion source metric \cr
relationship: has_metric_category MS:4000022 ! MS2 metric \cr
synonym: "IS-3A"  RELATED [PMID:19837981] \cr
synonym: "MS2 known precursor charges fractions"  RELATED [] \cr
synonym: "MS2-PrecZ-1" RELATED [PMID:24494671] \cr
synonym: "MS2-PrecZ-2" RELATED [PMID:24494671] \cr

MS:4000168 \cr
is_a: MS:4000001 ! QC metric \cr
is_a: MS:4000003 ! single value \cr
is_a: MS:4000008 ! ID based \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000020 ! ion source metric \cr
relationship: has_metric_category MS:4000022 ! MS2 metric \cr
synonym: "IS-3A"  RELATED [PMID:19837981] \cr
synonym: "MS2 known precursor charges fractions"  RELATED [] \cr
synonym: "MS2-PrecZ-1" RELATED [PMID:24494671] \cr
synonym: "MS2-PrecZ-2" RELATED [PMID:24494671] \cr

\code{NA} is returned if there are no features with precursor charge of 1+ or 
2+. \cr

An attribute containing the PSI:MS term will only be returned if 
\code{identificationLevel} is either \code{"all"} or \code{"identified"}.
}
\note{
The \code{Spectra} object might contain features that were not identified. If
the calculation needs to be done according to *MS:4000168*, the 
\code{Spectra} object should be prepared accordingly.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$precursorCharge <- c(1L, 1L, 1L)
sps <- Spectra(spd)
ratioCharge1over2(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake
}
