% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{precursorIntensityQuartiles}
\alias{precursorIntensityQuartiles}
\title{MS2 precursor intensity distribution (MS:4000116), 
identified MS2 precursor intensity distribution (MS:4000161), or
unidentified MS2 precursor intensity distribution (MS:4000162)}
\usage{
precursorIntensityQuartiles(
  spectra,
  msLevel = 1L,
  identificationLevel = c("all", "identified", "unidentified"),
  ...
)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{msLevel}{\code{integer}}

\item{identificationLevel}{\code{character(1)}, one of \code{"all"}, 
\code{"identified"}, or \code{"unidentified"}}

\item{...}{not used here}
}
\value{
\code{numeric(3)}
}
\description{
MS:4000116 \cr
"From the distribution of MS2 precursor intensities, the quantiles. E.g. a 
value triplet represents the quartiles Q1, Q2, Q3. The intensity 
distribution of the precursors informs about the dynamic range of the
acquisition." [PSI:MS] \cr

MS:40000161 \cr
From the distribution of identified MS2 precursor intensities, the quantiles. 
E.g. a value triplet represents the quartiles Q1, Q2, Q3. The intensity 
distribution of the precursors informs about 
the dynamic range of the acquisition in relation to identifiability. 
The used type of identification should be noted in the metadata or analysis 
methods section of the recording file for the respective run. In case of 
multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR 
should be used for better comparability." [PSI:MS]" \cr

id: MS:4000162 \cr
"From the distribution of unidentified MS2 precursor intensities, the 
quantiles. E.g. a value triplet represents the quartiles Q1, Q2, Q3.
The intensity distribution of the precursors informs about the 
dynamic range of the acquisition in relation to identifiability. The used 
type of identification should be noted in the metadata or analysis methods 
section of the recording file for the respective run. In case of multiple 
acceptance criteria (FDR) available in proteomics, PSM-level FDR should be 
used for better comparability." [PSI:MS]" \cr

The metric is calculated as follows: \cr
(1) the \code{Spectra} object is filtered according to the MS level, \cr 
(2) the intensity of the precursor ions within the \code{Spectra} object 
are obtained, \cr 
(3) the 25\%, 50\%, and 75\% quantile of the  precursor intensity values are 
obtained (\code{NA} values are removed) and returned. \cr
}
\details{
id: MS:4000116 \cr
is_a: MS:4000004 ! n-tuple \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000022 ! MS2 metric \cr
relationship: has_value_concept STATO:0000291 ! quantile \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV 
term \cr
relationship: has_units MS:1000043 ! intensity unit \cr

MS:4000161 \cr
is_a: MS:4000004 ! n-tuple \cr
is_a: MS:4000008 ! ID based \cr
relationship: has_metric_category MS:4000022 ! MS2 metric \cr
relationship: has_value_concept STATO:0000291 ! quantile \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV 
term \cr
relationship: has_units MS:1000043 ! intensity unit \cr

id: MS:4000162 \cr
is_a: MS:4000004 ! n-tuple \cr
is_a: MS:4000008 ! ID based \cr
relationship: has_metric_category MS:4000022 ! MS2 metric \cr
relationship: has_value_concept STATO:0000291 ! quantile \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV 
term \cr
relationship: has_units MS:1000043 ! intensity unit \cr
}
\note{
The \code{Spectra} object might contain features that were (not) identified. If
the calculation needs to be done according to *MS:4000161*/*MS:4000162*, the 
\code{Spectra} object should be prepared accordingly.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$precursorIntensity <- c(100.0, 100.0, 100.0)
sps <- Spectra(spd)

precursorIntensityQuartiles(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake
}
