% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbindFill.R
\name{rbindFill}
\alias{rbindFill}
\title{Combine R Objects by Row}
\usage{
rbindFill(...)
}
\arguments{
\item{...}{2 or more: \code{matrix}, \code{data.frame} or \code{DataFrame}.}
}
\value{
Depending on the input a single \code{matrix}, \code{data.frame} or
\code{DataFrame}.
}
\description{
This function combines instances of \code{matrix}, \code{data.frame} or \code{DataFrame}
objects into a single instance adding eventually missing columns (filling
them with \code{NA}s).
}
\note{
\code{rbindFill} might not work if one of the columns contains S4 classes.
}
\examples{
## Combine matrices
a <- matrix(1:9, nrow = 3, ncol = 3)
colnames(a) <- c("a", "b", "c")
b <- matrix(1:12, nrow = 3, ncol = 4)
colnames(b) <- c("b", "a", "d", "e")
rbindFill(a, b)
rbindFill(b, a, b)
}
\seealso{
Other helper functions for developers: 
\code{\link{between}()},
\code{\link{isPeaksMatrix}()},
\code{\link{validPeaksMatrix}()},
\code{\link{vapply1c}()},
\code{\link{which.first}()}
}
\author{
Johannes Rainer, Sebastian Gibb
}
\concept{helper functions for developers}
