% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refineCentroids.R
\name{.peakRegionMask}
\alias{.peakRegionMask}
\title{Peak Region Mask}
\usage{
.peakRegionMask(x, p, k = 30L)
}
\arguments{
\item{x}{\code{numeric}, e.g. intensity values.}

\item{p}{\code{integer}, indices of identified peaks/local maxima.}

\item{k}{\code{integer(1)}: maximum number of values left and right of the
peak that should be looked for valleys.}
}
\value{
A \code{matrix} with a column for each peak in \code{p} and \code{2 * k + 1}
rows where the middle row \code{k + 1} is the peak centroid. If the values is \code{1}
the index belongs to the peak region.
}
\description{
This function finds the mz region spanning by a peak. It creates an 0/1
matrix used for multiplications in other functions.
}
\examples{
ints <- c(5, 8, 12, 7, 4, 9, 15, 16, 11, 8, 3, 2, 3, 2, 9, 12, 14, 13, 8, 3)
mzs <- seq_along(ints)
peaks <- which(localMaxima(ints, hws = 3L))

m <- MsCoreUtils:::.peakRegionMask(ints, peaks, k = 5L)
}
\seealso{
Other extreme value functions: 
\code{\link{localMaxima}()},
\code{\link{refineCentroids}()},
\code{\link{valleys}()}
}
\author{
Sebastian Gibb
}
\concept{extreme value functions}
\keyword{internal}
