% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{recenterBindingSitesAcrossExperiments}
\alias{recenterBindingSitesAcrossExperiments}
\title{Combine binding sites across experiments}
\usage{
recenterBindingSitesAcrossExperiments(
  expLocations,
  experimentNames,
  expName = "combinedData",
  fdrValue = 0.05,
  fdrCrossExp = 0.001
)
}
\arguments{
\item{expLocations}{The path to the experiment folders}

\item{experimentNames}{Name of the experiment to be used in combined ChIP-seq}

\item{expName}{Name of the combined matrix}

\item{fdrValue}{FDR cut-off to accept binding in each ChIP-seq experiments}

\item{fdrCrossExp}{If no experiment fullfill this cutoff, the motif is not
considered}
}
\value{
A pariwise Pearson correlation matrix across experiments
}
\description{
Take experiment folder locations and experiment names and
 combine them into a combined matrix of motifs and ChIP-seq counts

Experiment folders must be generated either by
\code{\link{DetectBindingSitesBed}} or \code{\link{DetectBindingSitesMotif}}.
}
\examples{

# FUR candidate motifs in NC_000913 E. coli
FurMotifs=system.file("extdata", "FurMotifs.bed", package="Motif2Site")

# ChIP-seq datasets fe in bed single end format
IPFe <- c(system.file("extdata", "FUR_fe1.bed", package="Motif2Site"),
        system.file("extdata", "FUR_fe2.bed", package="Motif2Site"))
Inputs <- c(system.file("extdata", "Input1.bed", package="Motif2Site"),
            system.file("extdata", "Input2.bed", package="Motif2Site"))
FURfeBedInputStats <- 
  DetectBindingSitesBed(BedFile=FurMotifs,
   IPfiles=IPFe, 
   BackgroundFiles=Inputs, 
   genome="Ecoli",
   genomeBuild="20080805",
   DB="NCBI",
   expName="FUR_Fe_BedInput",
   format="BEDSE"
   )

# ChIP-seq datasets dpd in bed single end format
IPDpd <- c(system.file("extdata", "FUR_dpd1.bed", package="Motif2Site"),
        system.file("extdata", "FUR_dpd2.bed", package="Motif2Site"))
FURdpdBedInputStats <- 
  DetectBindingSitesBed(BedFile=FurMotifs,
   IPfiles=IPDpd, 
   BackgroundFiles=Inputs, 
   genome="Ecoli",
   genomeBuild="20080805",
   DB="NCBI",
   expName="FUR_Dpd_BedInput",
   format="BEDSE"
   )
                       

# Combine all FUR binding sites into one table
corMAT <- recenterBindingSitesAcrossExperiments(
    expLocations=c("FUR_Fe_BedInput","FUR_Dpd_BedInput"),
    experimentNames=c("FUR_Fe","FUR_Dpd"),
    expName="combinedFUR",
    )
corMAT

}
\seealso{
\code{\link{pairwisDifferential}}
}
