% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moonlight.R
\name{moonlight}
\alias{moonlight}
\title{moonlight pipeline}
\usage{
moonlight(
  cancerType = "panCancer",
  dataType = "Gene expression",
  directory = "GDCdata",
  BPname = NULL,
  cor.cut = 0.6,
  qnt.cut = 0.25,
  Genelist = NULL,
  fdr.cut = 0.01,
  logFC.cut = 1,
  corThreshold = 0.6,
  kNearest = 3,
  nGenesPerm = 10,
  DiffGenes = FALSE,
  nBoot = 100,
  nTF = NULL,
  nSample = NULL,
  thres.role = 0,
  stage = NULL,
  subtype = 0,
  samples = NULL
)
}
\arguments{
\item{cancerType}{select cancer type for which analysis should be run. panCancer
for all available cancer types in TCGA. Defaults to panCancer}

\item{dataType}{dataType}

\item{directory}{directory}

\item{BPname}{biological processes to use, if NULL: all processes will be used in analysis, RF for candidate; if not NULL the candidates for these processes will be determined (no learning)}

\item{cor.cut}{cor.cut Threshold}

\item{qnt.cut}{qnt.cut Threshold}

\item{Genelist}{Genelist}

\item{fdr.cut}{fdr.cut Threshold}

\item{logFC.cut}{logFC.cut Threshold}

\item{corThreshold}{corThreshold}

\item{kNearest}{kNearest}

\item{nGenesPerm}{nGenesPerm}

\item{DiffGenes}{DiffGenes}

\item{nBoot}{nBoot}

\item{nTF}{nTF}

\item{nSample}{nSample}

\item{thres.role}{thres.role}

\item{stage}{stage}

\item{subtype}{subtype}

\item{samples}{samples}
}
\value{
table with cancer driver genes TSG and OCG.
}
\description{
moonlight is a tool for identification of cancer driver genes. 
This function wraps the different steps of the complete analysis workflow.
Providing different solutions:
\enumerate{
\item MoonlighR::FEA
\item MoonlighR::URA
\item MoonlighR::PIA
}
}
\examples{
dataDEGs <- DPA(dataFilt = dataFilt, dataType = "Gene expression")
# to change with moonlight
}
