% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moonlight.R
\name{moonlight}
\alias{moonlight}
\title{moonlight pipeline}
\usage{
moonlight(
  dataDEGs,
  dataFilt,
  BPname = NULL,
  Genelist = NULL,
  kNearest = 3,
  nGenesPerm = 2000,
  DiffGenes = FALSE,
  nBoot = 400,
  nTF = NULL,
  thres.role = 0,
  dataMAF,
  path_cscape_coding,
  path_cscape_noncoding
)
}
\arguments{
\item{dataDEGs}{table of differentially expressed genes}

\item{dataFilt}{matrix of gene expression data with genes in rows and samples in columns}

\item{BPname}{biological processes to use, if NULL: all processes will be used in analysis, RF for candidate; if not NULL the candidates for these processes will be determined (no learning)}

\item{Genelist}{Genelist}

\item{kNearest}{kNearest}

\item{nGenesPerm}{nGenesPerm}

\item{DiffGenes}{DiffGenes}

\item{nBoot}{nBoot}

\item{nTF}{nTF}

\item{thres.role}{thres.role}

\item{dataMAF}{A MAF file rda object for DMA}

\item{path_cscape_coding}{A character string to path of CScape-somatic coding file}

\item{path_cscape_noncoding}{A character string to path of CScape-somatic non-coding file}
}
\value{
table with cancer driver genes TSG and OCG.
}
\description{
moonlight is a tool for identification of cancer driver genes.
This function wraps the different steps of the complete analysis workflow.
}
\examples{
\donttest{
drivers <- moonlight(dataDEGs = DEGsmatrix,
dataFilt = dataFilt,
BPname = c("apoptosis", "proliferation of cells"),
dataMAF = dataMAF,
path_cscape_coding = "css_coding.vcf.gz",
path_cscape_noncoding = "css_noncoding.vcf.gz")
}
}
