% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXenium.R
\name{readXenium}
\alias{readXenium}
\title{Read in Xenium data into a MoleculeExperiment object}
\usage{
readXenium(dataDir, keepCols = "essential", addBoundaries = "cell")
}
\arguments{
\item{dataDir}{Character string specifying the directory with the xenium
output files.}

\item{keepCols}{Vector of characters specifying the columns of interest from
the transcripts file and boundaries file. Can be "all" or "essential".
"essential" selects columns with gene names, x and y locations in the
transcripts file; "essential" selects columns with cell ids, and x and y
locations for the vertices defining the boundaries in the boundaries file.}

\item{addBoundaries}{Vector with which to specify the names of the boundary
assays to be added to the me object. Can be "cell", "nucleus", both, or NULL.
The latter will lead to the creation of a simple ME object with just the
molecules slot filled.}
}
\value{
A MoleculeExperiment object containing xenium data.
}
\description{
Function to read in, and standardise, Xenium output data into an ME object.
Detected transcripts files are required. Additionally, it is also possible
to read in boundary files ("cell", "nuclei", or both). This function is
a wrapper around readMolecules and readBoundaries functions.
}
\examples{
repoDir <- system.file("extdata", package = "MoleculeExperiment")
repoDir <- paste0(repoDir, "/xenium_V1_FF_Mouse_Brain")

me <- readXenium(repoDir,
                  keepCols = "essential")
me
}
