% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframeToMEList.R
\name{dataframeToMEList}
\alias{dataframeToMEList}
\title{Convert a transcript (molecule) or boundary dataframe to the ME list format}
\usage{
dataframeToMEList(
  df,
  dfType = NULL,
  assayName = NULL,
  sampleCol = "sample_id",
  factorCol = NULL,
  xCol = "x_location",
  yCol = "y_location",
  keepCols = "essential",
  scaleFactor = 1
)
}
\arguments{
\item{df}{A data.frame containing the transcript information or the
boundary information. NOTE: this dataframe should, at a minimum, have the
following 4 columns: sample_id, factorCol (e.g., feature_id in
transcripts, or cell_id in boundaries), x_location and y_location.}

\item{dfType}{Character string specifying contents of the dataframe. Can be
either "molecules" or "boundaries".}

\item{assayName}{Character string specifying the name with which to identify
the information later on in an ME object.}

\item{sampleCol}{Character string specifying the name of the column with the
sample id.}

\item{factorCol}{Character string specifying the name of the column with the
factors with which to group the data in the lists. When working with
molecules, this column would be e.g., "feature_id" in xenium. When working
with boundaries, this column would be e.g., "cell_id" in xenium.}

\item{xCol}{Character string specifying the name of the column with
global x coordinates.}

\item{yCol}{Character string specifying the name of the column with
global y coordinates.}

\item{keepCols}{Character string which can be either "essential" or "all".
If "essential", the function will only work with the x and y location
information.}

\item{scaleFactor}{Integer specifying the scale factor by which to change
the scale of the x and y locations (e.g., to change from pixel to micron).
The default value is 1.}
}
\value{
A list with the format required to input it into slots of a
MoleculeExperiment object.
}
\description{
The goal of this function is to standardise transcript and boundary files
for input to a MoleculeExperiment object.
}
\examples{
moleculesDf <- data.frame(
    sample_id = rep(c("sample1", "sample2"), times = c(30, 20)),
    features = rep(c("gene1", "gene2"), times = c(20, 30)),
    x_coords = runif(50),
    y_coords = runif(50)
)

moleculesMEList <- dataframeToMEList(moleculesDf,
                                  dfType = "molecules",
                                  assayName = "detected",
                                  sampleCol = "sample_id",
                                  factorCol = "features",
                                  xCol = "x_coords",
                                  yCol = "y_coords")

moleculesMEList
}
