% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_stat_taxa.R
\name{mp_stat_taxa}
\alias{mp_stat_taxa}
\alias{mp_stat_taxa,MPSE-method}
\alias{mp_stat_taxa,MPSE}
\alias{mp_stat_taxa,tbl_mpse-method}
\alias{mp_stat_taxa,tbl_mpse}
\alias{mp_stat_taxa,grouped_df_mpse-method}
\alias{mp_stat_taxa,grouped_df_mpse}
\title{Count the number and total number taxa for each sample at different taxonomy levels}
\usage{
mp_stat_taxa(.data, .abundance, action = "add", ...)

\S4method{mp_stat_taxa}{MPSE}(.data, .abundance, action = "add", ...)

\S4method{mp_stat_taxa}{tbl_mpse}(.data, .abundance, action = "add", ...)

\S4method{mp_stat_taxa}{grouped_df_mpse}(.data, .abundance, action = "add", ...)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the column name of abundance to be calculated}

\item{action}{a character "get" returns a table only contained the number and 
total number for each sample at different taxonomy levels, "only" returns a 
non-redundant tibble contained a nest column (StatTaxaInfo) and other sample information, 
"add" returns a update object (.data) contained a nest column (StatTaxaInfo).}

\item{...}{additional parameter}
}
\value{
update object or tbl_df according action argument
}
\description{
Count the number and total number taxa for each sample at different taxonomy levels
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%>\%
 mp_stat_taxa(.abundance=Abundance, action="only")
}
\author{
Shuangbin Xu
}
