% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_diff_analysis.R
\name{mp_plot_diff_manhattan}
\alias{mp_plot_diff_manhattan}
\alias{mp_plot_diff_manhattan,MPSE-method}
\alias{mp_plot_diff_manhattan,MPSE}
\alias{mp_plot_diff_manhattan,tbl_mpse-method}
\alias{mp_plot_diff_manhattan,tbl_mpse}
\alias{mp_plot_diff_manhattan,grouped_df_mpse-method}
\alias{mp_plot_diff_manhattan,grouped_df_mpse}
\title{displaying the differential result contained abundance and LDA with
manhattan plot.}
\usage{
mp_plot_diff_manhattan(
  .data,
  .group,
  .y = "fdr",
  .size = 2,
  taxa.class = "OTU",
  anno.taxa.class = NULL,
  removeUnknown = FALSE,
  ...
)

\S4method{mp_plot_diff_manhattan}{MPSE}(
  .data,
  .group,
  .y = "fdr",
  .size = 2,
  taxa.class = "OTU",
  anno.taxa.class = NULL,
  removeUnknown = FALSE,
  ...
)

\S4method{mp_plot_diff_manhattan}{tbl_mpse}(
  .data,
  .group,
  .y = "fdr",
  .size = 2,
  taxa.class = "OTU",
  anno.taxa.class = NULL,
  removeUnknown = FALSE,
  ...
)

\S4method{mp_plot_diff_manhattan}{grouped_df_mpse}(
  .data,
  .group,
  .y = "fdr",
  .size = 2,
  taxa.class = "OTU",
  anno.taxa.class = NULL,
  removeUnknown = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse after run 'mp_diff_analysis' with 'action="add"'.}

\item{.group}{the column name for mapping the different color.}

\item{.y}{the column name for mapping the y axis, default is 'fdr'.}

\item{.size}{the column name for mapping the size of points or numeric, default is 2.}

\item{taxa.class}{the taxonomy class features will be displayed, default is 'OTU'.}

\item{anno.taxa.class}{the taxonomy class to annotate the sign taxa with color, default is
'Phylum' if 'taxatree' is not empty.}

\item{removeUnknown}{logical whether mask the unknown taxonomy information but
differential species, default is FALSE.}

\item{...}{additional params, see also the 'geom_text_repel' and 'geom_point'.}
}
\description{
displaying the differential result contained abundance and LDA with
manhattan plot.
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%<>\%
  mp_rrarefy()
mouse.time.mpse
mouse.time.mpse \%<>\%
  mp_diff_analysis(.abundance=RareAbundance,
                   .group=time,
                   first.test.alpha=0.01,
                   action="add")
p <- mouse.time.mpse \%>\% 
       mp_plot_diff_manhattan(
           .group = Sign_time, 
           .y = fdr,
           .size = 2,
           taxa.class = OTU,
           anno.taxa.class = Phylum,
       )
}
