% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{mp_plot_abundance}
\alias{mp_plot_abundance}
\alias{mp_plot_abundance,MPSE-method}
\alias{mp_plot_abundance,MPSE}
\alias{mp_plot_abundance,tbl_mpse-method}
\alias{mp_plot_abundance,tbl_mpse}
\alias{mp_plot_abundance,grouped_df_mpse-method}
\alias{mp_plot_abundance,grouped_df_mpse}
\title{plotting the abundance of taxa via specified taxonomy class}
\usage{
mp_plot_abundance(
  .data,
  .abundance = NULL,
  .group = NULL,
  taxa.class = NULL,
  topn = 10,
  relative = TRUE,
  force = FALSE,
  plot.group = FALSE,
  geom = "flowbar",
  feature.dist = "bray",
  feature.hclust = "average",
  sample.dist = "bray",
  sample.hclust = "average",
  .sec.group = NULL,
  rmun = FALSE,
  rm.zero = TRUE,
  order.by.feature = FALSE,
  ...
)

\S4method{mp_plot_abundance}{MPSE}(
  .data,
  .abundance = NULL,
  .group = NULL,
  taxa.class = NULL,
  topn = 10,
  relative = TRUE,
  force = FALSE,
  plot.group = FALSE,
  geom = "flowbar",
  feature.dist = "bray",
  feature.hclust = "average",
  sample.dist = "bray",
  sample.hclust = "average",
  .sec.group = NULL,
  rmun = FALSE,
  rm.zero = TRUE,
  order.by.feature = FALSE,
  ...
)

\S4method{mp_plot_abundance}{tbl_mpse}(
  .data,
  .abundance = NULL,
  .group = NULL,
  taxa.class = NULL,
  topn = 10,
  relative = TRUE,
  force = FALSE,
  plot.group = FALSE,
  geom = "flowbar",
  feature.dist = "bray",
  feature.hclust = "average",
  sample.dist = "bray",
  sample.hclust = "average",
  .sec.group = NULL,
  rmun = FALSE,
  rm.zero = TRUE,
  order.by.feature = FALSE,
  ...
)

\S4method{mp_plot_abundance}{grouped_df_mpse}(
  .data,
  .abundance = NULL,
  .group = NULL,
  taxa.class = NULL,
  topn = 10,
  relative = TRUE,
  force = FALSE,
  plot.group = FALSE,
  geom = "flowbar",
  feature.dist = "bray",
  feature.hclust = "average",
  sample.dist = "bray",
  sample.hclust = "average",
  .sec.group = NULL,
  rmun = FALSE,
  rm.zero = TRUE,
  order.by.feature = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE object or tbl_mpse object}

\item{.abundance}{the column name of abundance to be plotted.}

\item{.group}{the column name of group to be calculated and plotted,
default is NULL.}

\item{taxa.class}{name of taxonomy class, default is NULL, meaning the
Phylum class will be plotted.}

\item{topn}{integer the number of the top most abundant, default is 10.}

\item{relative}{logical whether calculate the relative abundance and plotted.}

\item{force}{logical whether calculate the relative abundance forcibly
when the abundance is not be rarefied, default is FALSE.}

\item{plot.group}{logical whether plotting the abundance of specified taxa.class 
taxonomy with group not sample level, default is FALSE.}

\item{geom}{character which type plot, options is 'flowbar' 'bar' and 'heatmap', default is
'flowbar'.}

\item{feature.dist}{character the method to calculate the distance between the features,
based on the '.abundance' of 'taxa.class', default is 'bray', options refer to
the 'distmethod' of [mp_cal_dist()] (except unifrac related).}

\item{feature.hclust}{character the agglomeration method for the features, default is
'average', options are 'single', 'complete', 'average', 'ward.D', 'ward.D2', 'centroid'
'median' and 'mcquitty'.}

\item{sample.dist}{character the method to calculate the distance between the samples
based on the '.abundance' of 'taxa.class', default is 'bray', options refer to the 
'distmethod' of [mp_cal_dist()] (except unifrac related).}

\item{sample.hclust}{character the agglomeration method for the samples, default is
'average', options are 'single', 'complete', 'average', 'ward.D', 'ward.D2', 'centroid'
'median' and 'mcquitty'.}

\item{.sec.group}{the column name of second group to be plotted with nested facet,
default is NULL, this argument will be deprecated in the next version.}

\item{rmun}{logical whether to group the unknown taxa to \code{Others} category, 
such as "g__un_xxx", default is FALSE, meaning do not group them to \code{Others} category.}

\item{rm.zero}{logical whether to display the zero abundance, which only work with geom='heatmap'
default is TRUE.}

\item{order.by.feature}{character adjust the order of axis x, default is FALSE, if it is NULL or TRUE,
meaning the order of axis.x will be visualizing with the order of samples by highest abundance of features.}

\item{...}{additional parameters, when the geom = "flowbar", it can specify the parameters of 
'geom_stratum' of 'ggalluvial', when the geom = 'bar', it can specify the parameters of 
'geom_bar' of 'ggplot2', when the geom = "heatmap", it can specify the parameter of
'geom_tile' of 'ggplot2'.}
}
\description{
plotting the abundance of taxa via specified taxonomy class
}
\examples{
\dontrun{
data(mouse.time.mpse)
mouse.time.mpse \%<>\%
  mp_rrarefy()
mouse.time.mpse
mouse.time.mpse \%<>\%
  mp_cal_abundance(.abundance=RareAbundance, action="add") \%>\%
  mp_cal_abundance(.abundance=RareAbundance, .group=time, action="add")
mouse.time.mpse
p1 <- mouse.time.mpse \%>\%
      mp_plot_abundance(.abundance=RelRareAbundanceBySample, 
                        .group=time, 
                        taxa.class="Phylum", 
                        topn=20)
p2 <- mouse.time.mpse \%>\%
      mp_plot_abundance(.abundance = Abundance,
                        taxa.class = Phylum,
                        topn = 20,
                        relative = FALSE,
                        force = TRUE
                       )
p3 <- mouse.time.mpse \%>\%
      mp_plot_abundance(.abundance = RareAbundance, 
                        .group = time,
                        taxa.class = Phylum, 
                        topn = 20,
                        relative = FALSE,
                        force = TRUE
                        )
p4 <- mouse.time.mpse \%>\%
      mp_plot_abundance(.abundance = RareAbundance,
                        .group = time,
                        taxa.class = Phylum,
                        topn = 20,
                        relative = FALSE,
                        force = TRUE,
                        plot.group = TRUE
                        )
}
}
\author{
Shuangbin Xu
}
