% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-accessor.R
\name{mp_extract_abundance}
\alias{mp_extract_abundance}
\alias{mp_extract_abundance,MPSE-method}
\alias{mp_extract_abundance,MPSE}
\alias{mp_extract_abundance,tbl_mpse-method}
\alias{mp_extract_abundance,tbl_mpse}
\alias{mp_extract_abundance,grouped_df_mpse-method}
\alias{mp_extract_abundance,grouped_df_mpse}
\title{Extracting the abundance metric from MPSE or tbl_mpse object}
\usage{
mp_extract_abundance(x, taxa.class = "all", topn = NULL, rmun = FALSE, ...)

\S4method{mp_extract_abundance}{MPSE}(x, taxa.class = "all", topn = NULL, rmun = FALSE, ...)

\S4method{mp_extract_abundance}{tbl_mpse}(x, taxa.class = "all", topn = NULL, rmun = FALSE, ...)

\S4method{mp_extract_abundance}{grouped_df_mpse}(x, taxa.class = "all", topn = NULL, rmun = FALSE, ...)
}
\arguments{
\item{x}{MPSE or tbl_mpse object}

\item{taxa.class}{character the name of taxonomy 
class level what you want to extract}

\item{topn}{integer the number of the top most abundant, default
is NULL.}

\item{rmun}{logical whether to remove the unknown taxa, such as "g__un_xxx",
default is FALSE (the unknown taxa class will be considered as 'Others').}

\item{...}{additional parameters}
}
\description{
Extracting the abundance metric from the MPSE or tbl_mpse,
the 'mp_cal_abundance' must have been run with action='add'.
}
\author{
Shuangbin Xu
}
