% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_upset.R
\name{mp_cal_upset}
\alias{mp_cal_upset}
\alias{mp_cal_upset,MPSE-method}
\alias{mp_cal_upset,MPSE}
\alias{mp_cal_upset,tbl_mpse-method}
\alias{mp_cal_upset,tbl_mpse}
\alias{mp_cal_upset,grouped_df_mpse-method}
\alias{mp_cal_upset,grouped_df_mpse}
\title{Calculating the samples or groups for each OTU, the result can be visualized by 'ggupset'}
\usage{
mp_cal_upset(
  .data,
  .group,
  .abundance = NULL,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_upset}{MPSE}(
  .data,
  .group,
  .abundance = NULL,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_upset}{tbl_mpse}(
  .data,
  .group,
  .abundance = NULL,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_upset}{grouped_df_mpse}(
  .data,
  .group,
  .abundance = NULL,
  action = "add",
  force = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.group}{the name of group to be calculated.
if it is no provided, the sample will be used.}

\item{.abundance}{the name of otu abundance to be calculated.
if it is null, the rarefied abundance will be used.}

\item{action}{character, "add" joins the new information to the tibble of tbl_mpse or 
rowData of MPSE. "only" and "get" return a non-redundant tibble with the just new information. 
which is a treedata object.}

\item{force}{logical whether calculate the relative abundance forcibly when the abundance
is not be rarefied, default is FALSE.}

\item{...}{additional parameters.}
}
\value{
update object or tibble according the 'action'
}
\description{
Calculating the samples or groups for each OTU, the result can be visualized by 'ggupset'
}
\examples{
data(mouse.time.mpse)
mpse <- mouse.time.mpse \%>\%
        mp_rrarefy() \%>\%
        mp_cal_upset(.abundance=RareAbundance, .group=time, action="add")
mpse
library(ggplot2)
library(ggupset)
p <- mpse \%>\% mp_plot_upset(.group=time, .upset=ggupsetOftime)
p
# or set action="only"
\dontrun{
tbl <- mouse.time.mpse \%>\% 
       mp_rrarefy() \%>\% 
       mp_cal_upset(.abundance=RareAbundance, .group=time, action="only") 
tbl
p2 <- tbl \%>\%
      ggplot(aes(x=ggupsetOftime)) +
      geom_bar() +
      ggupset::scale_x_upset() +
      ggupset::theme_combmatrix(combmatrix.label.extra_spacing=30)
}
}
\seealso{
[mp_plot_upset()]
}
\author{
Shuangbin Xu
}
