% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_dist.R
\name{mp_cal_dist}
\alias{mp_cal_dist}
\alias{mp_cal_dist,MPSE-method}
\alias{mp_cal_dist,MPSE}
\alias{mp_cal_dist,tbl_mpse-method}
\alias{mp_cal_dist,tbl_mpse}
\alias{mp_cal_dist,grouped_df_mpse-method}
\alias{mp_cal_dist,grouped_df_mpse}
\title{Calculate the distances between the samples or features with specified abundance.}
\usage{
mp_cal_dist(
  .data,
  .abundance,
  .env = NULL,
  distmethod = "bray",
  action = "add",
  scale = FALSE,
  cal.feature.dist = FALSE,
  ...
)

\S4method{mp_cal_dist}{MPSE}(
  .data,
  .abundance,
  .env = NULL,
  distmethod = "bray",
  action = "add",
  scale = FALSE,
  cal.feature.dist = FALSE,
  ...
)

\S4method{mp_cal_dist}{tbl_mpse}(
  .data,
  .abundance,
  .env = NULL,
  distmethod = "bray",
  action = "add",
  scale = FALSE,
  cal.feature.dist = FALSE,
  ...
)

\S4method{mp_cal_dist}{grouped_df_mpse}(
  .data,
  .abundance,
  .env = NULL,
  distmethod = "bray",
  action = "add",
  scale = FALSE,
  cal.feature.dist = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of otu abundance to be calculated}

\item{.env}{the column names of continuous environment factors,
default is NULL.}

\item{distmethod}{character the method to calculate distance.
option is "manhattan", "euclidean", "canberra", "bray", "kulczynski", 
"jaccard", "gower", "altGower", "morisita", "horn", "mountford", "raup",
"binomial", "chao", "cao", "mahalanobis", "chisq", "chord", "aitchison", 
"robust.aitchison" (implemented in vegdist of vegan), and "w", "-1", "c",
"wb", "r", "I", "e", "t", "me", "j", "sor", "m", "-2", "co", "cc", "g", 
"-3", "l", "19", "hk", "rlb", "sim", "gl", "z" (implemented in betadiver of 
vegan), "maximum", "binary", "minkowski" (implemented in dist 
of stats), "unifrac", "weighted unifrac" (implemented in phyloseq), "cor", "abscor", 
"cosangle", "abscosangle" (implemented in hopach), or other customized distance function.}

\item{action}{character, "add" joins the distance data to the object, "only" return
a non-redundant tibble with the distance information. "get" return 'dist' object.}

\item{scale}{logical whether scale the metric of environment (.env is provided) before
the distance was calculated, default is FALSE. The environment matrix can be processed
when it was joined to the MPSE or tbl_mpse object.}

\item{cal.feature.dist}{logical whether to calculate the distance between the features.
default is FALSE, meaning calculate the distance between the samples.}

\item{...}{additional parameters.

some dot arguments if \code{distmethod} is \code{unifrac} or \code{weighted unifrac}:
\itemize{
  \item \code{weighted} logical, whether to use weighted-UniFrac calculation, which considers the relative 
    abundance of taxa, default is FALSE, meaning unweightrd-UniFrac, which only considers 
    presence/absence of taxa.
  \item \code{normalized} logical, whether normaized the branch length of tree to the range between 0 and 1 
    when the \code{weighted}=\code{TRUE}.
  \item \code{parallel} logical, whether to execute the calculation in parallel, default is FALSE.
}}
}
\value{
update object or tibble according the 'action'
}
\description{
Calculate the distances between the samples or features with specified abundance.
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%<>\%
    mp_decostand(.abundance=Abundance) \%>\% 
    mp_cal_dist(.abundance=hellinger, distmethod="bray")
mouse.time.mpse
p1 <- mouse.time.mpse \%>\%
        mp_plot_dist(.distmethod = bray)
p2 <- mouse.time.mpse \%>\%
        mp_plot_dist(.distmethod = bray, .group = time, group.test = TRUE)
p3 <- mouse.time.mpse \%>\%
        mp_plot_dist(.distmethod = bray, .group = time)
# adjust the legend of heatmap of distance between the samples.
# the p3 is a aplot object, we define set_scale_theme to adjust the 
# character (color, size or legend size) of figure with specified 
# 'aes_var' according to legend title. 
library(ggplot2)
p3 \%>\% 
   set_scale_theme(
     x = scale_size_continuous(
       range = c(0.1, 4), 
       guide = guide_legend(keywidth = 0.5, keyheight = 1)), 
     aes_var = bray
   ) \%>\% 
   set_scale_theme(
     x = scale_colour_gradient(
       guide = guide_legend(keywidth = 0.5, keyheight = 1)), 
     aes_var = bray
   ) \%>\% 
   set_scale_theme(
     x = scale_fill_manual(values = c("orangered", "deepskyblue"), 
       guide = guide_legend(keywidth = 0.5, keyheight = 0.5, label.theme = element_text(size=6))), 
     aes_var = time) \%>\% 
   set_scale_theme(
     x = theme(axis.text=element_text(size=6), panel.background=element_blank()), 
     aes_var = bray
   )
\dontrun{
# Visualization manual
library(ggplot2)
tbl <- mouse.time.mpse \%>\%
       mp_extract_dist(distmethod="bray", .group=time)
tbl
tbl \%>\% 
  ggplot(aes(x=GroupsComparison, y=bray)) + 
  geom_boxplot(aes(fill=GroupsComparison)) + 
  geom_jitter(width=0.1) + 
  xlab(NULL) +
  theme(legend.position="none")
}
}
\seealso{
[mp_extract_dist()] and [mp_plot_dist()]
}
\author{
Shuangbin Xu
}
