% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ggrarecurve.R
\name{ggrarecurve}
\alias{ggrarecurve}
\alias{ggrarecurve.phyloseq}
\alias{ggrarecurve.data.frame}
\alias{ggrarecurve.rarecurve}
\title{Rarefaction alpha index}
\usage{
ggrarecurve(obj, ...)

\method{ggrarecurve}{phyloseq}(obj, chunks = 400, factorLevels = NULL, ...)

\method{ggrarecurve}{data.frame}(obj, sampleda, factorLevels, chunks = 400, ...)

\method{ggrarecurve}{rarecurve}(
  obj,
  indexNames = "Observe",
  linesize = 0.5,
  facetnrow = 1,
  shadow = TRUE,
  factorNames,
  se = FALSE,
  method = "lm",
  formula = y ~ log(x),
  ...
)
}
\arguments{
\item{obj}{phyloseq, phyloseq class or data.frame
shape of data.frame (nrow sample * ncol feature ( + factor)).}

\item{...}{additional parameters, 
see also \code{\link{ggplot2}{ggplot}}.}

\item{chunks}{integer, the number of subsample in a sample,
default is 400.}

\item{factorLevels}{list, the levels of the factors, default is NULL,
if you want to order the levels of factor, you can set this.}

\item{sampleda}{data.frame, (nrow sample * ncol factor)}

\item{indexNames}{character, default is "Observe",
only for "Observe", "Chao1", "ACE".}

\item{linesize}{integer, default is 0.5.}

\item{facetnrow}{integer, the nrow of facet, default is 1.}

\item{shadow}{logical, whether merge samples with group (factorNames) and
display the ribbon of group, default is TRUE.}

\item{factorNames}{character, default is missing.}

\item{se}{logical, default is FALSE.}

\item{method}{character, default is lm.}

\item{formula}{formula, default is `y ~ log(x)`}
}
\value{
figure of rarefaction curves
}
\description{
Rarefaction alpha index
}
\examples{
\dontrun{
data(test_otu_data)
test_otu_data \%<>\% as.phyloseq()
library(ggplot2)
prare <- ggrarecurve(test_otu_data,
               indexNames=c("Observe","Chao1","ACE"),
               shadow=FALSE,
               factorNames="group"
         ) +
         theme(legend.spacing.y=unit(0.02,"cm"),
               legend.text=element_text(size=6))
}
}
\author{
Shuangbin Xu
}
