% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff-ml-utilities.R
\name{get_sampledflist}
\alias{get_sampledflist}
\title{Generate random data list from a original data.}
\usage{
get_sampledflist(dalist, bootnums = 30, ratio = 0.7, makerownames = FALSE)
}
\arguments{
\item{dalist}{list, a list contained multi data.frame.}

\item{bootnums}{integer, the number of bootstrap iteration, default is 30.}

\item{ratio}{numeric, the ratios of each data.frame to keep.}

\item{makerownames}{logical, whether build row.names,default is FALSE.}
}
\value{
the list contained the data.frame generated by bootstrap iteration.
}
\description{
Generate random data list from a original data.
}
\examples{
\dontrun{
    data(iris)
    irislist <- split(iris, iris$Species)
    set.seed(1024)
    irislist <- get_sampledflist(irislist)
}
}
\author{
Shuangbin Xu
}
