% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_pca.R
\name{get_pca}
\alias{get_pca}
\alias{get_pca.data.frame}
\alias{get_pca.phyloseq}
\title{Performs a principal components analysis}
\usage{
get_pca(obj, ...)

\method{get_pca}{data.frame}(obj, sampleda = NULL, method = "hellinger", ...)

\method{get_pca}{phyloseq}(obj, method = "hellinger", ...)
}
\arguments{
\item{obj}{phyloseq, phyloseq class or data.frame
shape of data.frame is nrow sample * ncol feature.}

\item{...}{additional parameters, see\code{\link[stats]{prcomp}}.}

\item{sampleda}{data.frame, nrow sample * ncol factors.}

\item{method}{character, the standardization methods for
community ecologists. see \code{\link[vegan]{decostand}}.}
}
\value{
pcasample class, contained prcomp class and sample information.
}
\description{
Performs a principal components analysis
}
\examples{
\dontrun{
library(phyloseq)
data(GlobalPatterns)
subGlobal <- subset_samples(GlobalPatterns, 
         SampleType \%in\% c("Feces", "Mock", "Ocean", "Skin"))
pcares <- get_pca(subGlobal, method="hellinger")
pcaplot <- ggordpoint(pcares, biplot=TRUE, 
                      speciesannot=TRUE,
                      factorNames=c("SampleType"), ellipse=TRUE)
}
}
