% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_dist.R
\name{get_dist}
\alias{get_dist}
\alias{get_dist.data.frame}
\alias{get_dist.phyloseq}
\title{calculate distance}
\usage{
get_dist(obj, ...)

\method{get_dist}{data.frame}(
  obj,
  distmethod = "euclidean",
  taxa_are_rows = FALSE,
  sampleda = NULL,
  tree = NULL,
  method = "hellinger",
  ...
)

\method{get_dist}{phyloseq}(obj, distmethod = "euclidean", method = "hellinger", ...)
}
\arguments{
\item{obj}{phyloseq, phyloseq class or data.frame
nrow sample * ncol feature.}

\item{..., }{additional parameters.}

\item{distmethod}{character, default is "euclidean", 
see also \code{\link[phyloseq]{distanceMethodList}}}

\item{taxa_are_rows}{logical, default is FALSE.}

\item{sampleda}{data.frame, nrow sample * ncol factors.}

\item{tree}{object, the phylo class, see also \code{\link[ape]{as.phylo}}.}

\item{method}{character, default is hellinger, 
see alse \code{\link[vegan]{decostand}}}
}
\value{
distance class contianed distmethod and originalD attr
}
\description{
calculate distance
}
\examples{
\dontrun{
data(test_otu_data)
test_otu_data \%<>\% as.phyloseq()
distclass <- get_dist(test_otu_data)
hcsample <- get_clust(distclass)
}
}
\seealso{
\code{\link[phyloseq]{distance}}
}
