% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_filter_taxa.R
\name{drop_taxa}
\alias{drop_taxa}
\alias{drop_taxa,data.frame-method}
\alias{drop_taxa,data.frame}
\alias{drop_taxa,phyloseq-method}
\alias{drop_taxa,phyloseq}
\title{Dropping Species with Few abundance and Few Occurrences}
\usage{
drop_taxa(obj, ...)

\S4method{drop_taxa}{data.frame}(obj, minocc = 0, minabu = 0, ...)

\S4method{drop_taxa}{phyloseq}(obj, ...)
}
\arguments{
\item{obj}{object, phyloseq or a dataframe of species (n_sample, n_feature).}

\item{..., }{additional parameters.}

\item{minocc}{numeric, the threshold number of occurrences to be 
dropped, if < 1.0,it will be the threshold ratios of occurrences, 
default is 0.}

\item{minabu}{numeric, the threshold abundance, if fewer than the 
threshold will be dropped, default is 0.}
}
\value{
dataframe of new features.
}
\description{
Drop species or features from the feature data frame or phyloseq that occur
fewer than or equal to a threshold number of occurrences and fewer 
abundance than to a threshold abundance.
}
\examples{
\dontrun{
otudafile <- system.file("extdata", "otu_tax_table.txt",
                         package="MicrobiotaProcess")
otuda <- read.table(otudafile, sep="\t", 
                    header=TRUE, row.names=1, 
                    check.names=FALSE, skip=1, 
                    comment.char="")
otuda <- otuda[sapply(otuda, is.numeric)]
otuda <- data.frame(t(otuda), check.names=FALSE)
dim(otuda)
otudat <- drop_taxa(otuda, minocc=0.1, minabu=1)
dim(otudat)
data(test_otu_data)
test_otu_data \%<>\% as.phyloseq()
keepps <- drop_taxa(test_otu_data, minocc=0.1, minabu=0)
}
}
\author{
Shuangbin Xu
}
