% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Download_Preprocess.R
\name{Download_GeneExpression}
\alias{Download_GeneExpression}
\title{The Download_GeneExpression function}
\usage{
Download_GeneExpression(CancerSite, TargetDirectory, downloadData = TRUE)
}
\arguments{
\item{CancerSite}{character of length 1 with TCGA cancer code.}

\item{TargetDirectory}{character with directory where a folder for downloaded files will be created.}

\item{downloadData}{logical indicating if data should be downloaded (default: TRUE). If false, the url of the desired data is returned.}
}
\value{
list with paths to downloaded files for both 27k and 450k methylation data.
}
\description{
Downloads gene expression data from TCGA.
}
\details{
This function downloads RNAseq data (file tag "mRNAseq_Preprocess.Level_3"), with the exception for OV and GBM, for which micro array data is
downloaded since there is not enough RNAseq data
}
\examples{
\dontrun{

# Optional register cluster to run in parallel
library(doParallel)
cl <- makeCluster(5)
registerDoParallel(cl)

# Gene expression data for ovarian cancer
cancerSite <- "OV"
targetDirectory <- paste0(getwd(), "/")

# Downloading gene expression data
GEdirectories <- Download_GeneExpression(cancerSite, targetDirectory, TRUE)

# Processing gene expression data
GEProcessedData <- Preprocess_GeneExpression(cancerSite, GEdirectories)

# Saving gene expression processed data
saveRDS(GEProcessedData, file = paste0(targetDirectory, "GE_", cancerSite, "_Processed.rds"))

stopCluster(cl)
}

}
\keyword{download}
