% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoPath.R
\name{cytoPath}
\alias{cytoPath}
\title{Map Differentially Expressed Genes to Dysregulated Pathways}
\usage{
cytoPath(
    pathway,
    DEGpath,
    figpath,
    genename,
    headers = c("log2FoldChange", "padj")
)
}
\arguments{
\item{pathway}{character, the name of the pathway to be visualized}

\item{DEGpath}{character, the path to a DEG file by DESeq2 or limma}

\item{figpath}{character, the path to which the figure will be saved}

\item{genename}{character, column name with HUGO Gene Names in DEG file}

\item{headers}{character vector of length 2 in the form c(log fold change
col name, adjusted p value col name)}
}
\value{
cytoPath() Returns a Cytoscape figure of DEG data on rWikiPathways
}
\description{
requires the package RCy3 and a local instance of Cytoscape
}
\examples{
\donttest{
cytoPath(pathway = "Tryptophan Metabolism",
        DEGpath = system.file("extdata/BRCA_DEGS.csv", package = "MetaPhOR"),
        figpath = file.path(tempdir(), "example_map"),
        genename = "X",
        headers = c("logFC", "adj.P.Val"))
}
}
