% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plots symmetric AUROC heatmap, clustering cell types by similarity.}
\usage{
plotHeatmap(aurocs, cex = 1, margins = c(8, 8), ...)
}
\arguments{
\item{aurocs}{A square AUROC matrix as returned by MetaNeighborUS.}

\item{cex}{Size factor for row and column labels.}

\item{margins}{Size of margins (for row and column labels).}

\item{...}{Additional graphical parameters that are passed on to
gplots::heatmap.2 (allows customization of the heatmap).}
}
\description{
Plots symmetric AUROC heatmap, clustering cell types by similarity.
}
\examples{
data(mn_data)
var_genes = variableGenes(dat = mn_data, exp_labels = mn_data$study_id)
celltype_NV = MetaNeighborUS(var_genes = var_genes,
                             dat = mn_data,
                             study_id = mn_data$study_id,
                             cell_type = mn_data$cell_type)
plotHeatmap(celltype_NV)

}
\seealso{
\code{\link{ggPlotHeatmap}}
}
