% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaAnalysis.R
\name{metaAnalysis}
\alias{metaAnalysis}
\title{Performs meta-analysis}
\usage{
metaAnalysis(value, variableOfInterst, otherVariables, studyID, data, CILevel,
  main, ifScale = c(TRUE, FALSE), cex = 1)
}
\arguments{
\item{value}{A string to specify the column name of the dependent variable
(y)}

\item{variableOfInterst}{A string to specify the column name of the
independent variable of interest (x1)}

\item{otherVariables}{A string vector to specify the column names of
independent variables included in the regression model other than the
variableOfInterst.}

\item{studyID}{A string to specify the column name of study ID.}

\item{data}{A data frame containing the data}

\item{CILevel}{A number between 0 to 1, used to specify the confidence
interval to be plotted in the forest plot.}

\item{main}{A string to specify the title of the forest plot}

\item{ifScale}{A vector of two logic values, specifying if the dependent
variable and the variableOfInterst should be scaled when calculating the
effect size.}

\item{cex}{A number specifying the amount by which plotting text and symbols
should be scaled relative to the default in the forest plot.}
}
\value{
Returns data frame describing the effect size of variableOfInterst on
  value in each individual studies, as well as the over all effect size. In addition, it returns the
  random effect model and the leave one out analysis result.
}
\description{
A function that performs meta-analysis
}
\examples{
library(dplyr)
#collect all summary statistics
fn=system.file("extdata","",package="MetaCyto")
files=list.files(fn,pattern="cluster_stats_in_each_sample",recursive=TRUE,
                 full.names=TRUE)
fcs_stats=collectData(files,longform=TRUE)
# Collect sample information
files=list.files(fn,pattern="sample_info",recursive=TRUE,full.names=TRUE)
sample_info=collectData(files,longform=FALSE)
# join the cluster summary statistics with sample information
all_data=inner_join(fcs_stats,sample_info,by="fcs_files")

# plot forrest plot to see if the proportion of CCR7+ CD8 T cell
# is affected by age (while controlling for Gender)
L="CD3+|CD4-|CD8+|CCR7+"
dat=subset(all_data,all_data$parameter_name=="fraction"&
            all_data$label==L)
MA=metaAnalysis(value="value",variableOfInterst="Subject Age",main=L,
                otherVariables=c("Gender"),studyID="study_id",
                data=dat,CILevel=0.95,ifScale=c(TRUE,FALSE))
}
