% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_na_class.R
\name{filter_na}
\alias{filter_na}
\title{Filter by missing values}
\usage{
filter_na(column_name, mode = "exclude", ...)
}
\arguments{
\item{column_name}{(character) The column name to use for filtering.}

\item{mode}{(character) Filter mode. Allowed values are limited to
the following: \itemize{ \item{\code{"include"}: Rows with NA are
kept and all others removed.}\item{\code{"exclude"}: Rows with NA are
excluded and all other kept.}} The default is \code{"exclude"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{filter_na} object with the following \code{output}
slots:
\tabular{ll}{
\code{filtered} \tab (annotation_source) Annotation_source after
filtering. \cr
\code{flags} \tab (data.frame) A list of flags indicating which
annotations were removed. \cr
}
}
\description{
Filters annotations where the named column is NA
}
\section{Inheritance}{

A \code{filter_na} object inherits the following \code{struct} classes: \cr\cr
\verb{[filter_na]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- filter_na(
        column_name = "V1",
        mode = "exclude")

}
