% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocFileCache_database_class.R
\name{BiocFileCache_database}
\alias{BiocFileCache_database}
\title{Cached database}
\usage{
BiocFileCache_database(
  source,
  bfc_path = NULL,
  resource_name,
  bfc_fun = cache_as_is,
  import_fun = read.csv,
  offline = FALSE,
  ...
)
}
\arguments{
\item{source}{(ANY) The source of annotation data.}

\item{bfc_path}{(character, NULL) \code{BiocFileCache} is used to cache
the database locally and prevent unnecessary downloads. If a path is
provided then \code{BiocFileCache} will use this location. If NULL it will
use the default location (see \code{\link[BiocFileCache:BiocFileCache-class]{BiocFileCache::BiocFileCache()}} for
details). The default is \code{NULL}.}

\item{resource_name}{(character) The name given to this resource in
the cache. (see \code{\link[BiocFileCache:BiocFileCache-class]{BiocFileCache::BiocFileCache()}} for details).}

\item{bfc_fun}{(function) A function to process the object before
storing it in the cache, e.g. to store an unzipped file in the cache
instead of the zipped version. This would prevent needing to unzip
the resource each time it is retrieved from the cache, but would mean
using more space on disk. The default function does nothing to the
resource. See \code{\link[BiocFileCache:BiocFileCache-class]{BiocFileCache::bfcdownload()}} for details.}

\item{import_fun}{(function) A function to process the object after
retrieving it from the cache e.g. it might need to be unzipped before
importingas a data.frame. This function should take the path to the
cached object as the first input and return a data.frame.}

\item{offline}{(logical) If \code{offline = FALSE} then checks to
determine if the resource has expired will be skipped, and retrieved
directly from the cache. The default is \code{FALSE}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
BiocFileCache_database
} object. This object has no \code{output} slots.
}
\description{
A cached resource using BiocFileCache.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{BiocFileCache}}}
}
\section{Inheritance}{

A \code{BiocFileCache_database} object inherits the following \code{struct}
classes: \cr\cr
\verb{[BiocFileCache_database]} -> \verb{[annotation_database]} ->
\verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- BiocFileCache_database(
        bfc_path = NULL,
        resource_name = "bfc",
        bfc_fun = function(){},
        import_fun = function(){},
        offline = FALSE,
        tag = character(0),
        data = data.frame(),
        source = "ANY")

}
\references{
Shepherd L, Morgan M (2025). \emph{BiocFileCache: Manage Files
Across Sessions}. doi:10.18129/B9.bioc.BiocFileCache
\url{https://doi.org/10.18129/B9.bioc.BiocFileCache}, R package version
2.99.6, \url{https://bioconductor.org/packages/BiocFileCache}.
}
\seealso{
Other database: 
\code{\link{sqlite_database}}
}
\concept{database}
