% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyApp.R
\name{printInformationSelect}
\alias{printInformationSelect}
\title{Display information on connected features of selected features}
\usage{
printInformationSelect(
  select,
  sps = NULL,
  linkDfInd,
  linkDf,
  similarityMatrix,
  roundDigits = 2
)
}
\arguments{
\item{select}{\code{character}, obtained from \code{groupname}, 
\code{character} of selected feature}

\item{sps}{\code{Spectra} object containing spectra that are compared in 
\code{similarityMatrix}}

\item{linkDfInd}{\code{numeric} indices of selected features}

\item{linkDf}{\code{data.frame} that contains information of linked features 
for given thresholds}

\item{similarityMatrix}{\code{matrix} that is used to get information on the 
degree of similarity, \code{similarityMatrix} is an ordered version of a 
similarity matrix, see \code{?orderSimilarityMatrix}}

\item{roundDigits}{\code{numeric(1)},  how many digits should be displayed?}
}
\value{
\code{character} that is in HTML format
}
\description{
Displays information on connected features of selected features.
}
\details{
\code{printInformationSelect} is for internal use.
}
\examples{
data("spectra", package = "MetCirc")
sps_tissue@metadata$names <- rep("Unknown", 259)
sps_tissue@metadata$information <- rep("Unknown", 259)
sps_tissue@metadata$classes <- rep("Unknown", 259)
sps_tissue@metadata$adduct <- rep("Unknown", 259)
similarityMat <- Spectra::compareSpectra(sps_tissue[1:10],
    FUN = MsCoreUtils::ndotproduct, ppm = 20, m = 0.5, n = 2)
rownames(similarityMat) <- colnames(similarityMat) <- sps_tissue$name[1:10]
linkDf <- createLinkDf(similarityMatrix = similarityMat,
    sps = sps_tissue[1:10], 
    condition = c("SPL", "LIM", "ANT", "STY"), lower = 0.01, upper = 1)
    
## cut link data.frame (here: only display links between groups)
linkDf_cut <- cutLinkDf(linkDf, type = "inter")
groupname <- c(as.character(linkDf_cut[, "spectrum1"]),
            as.character(linkDf_cut[, "spectrum2"]))
groupname <- unique(groupname)

## arbitrarily select a feature
ind <- 2
linkDfInds <- getLinkDfIndices(groupname[ind], linkDf_cut)
MetCirc:::printInformationSelect(select = groupname[ind], 
    sps = sps_tissue[1:10], linkDfInd = linkDfInds, 
    linkDf = linkDf_cut, similarityMatrix = similarityMat)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
