% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{plotCV}
\alias{plotCV}
\title{Plot CV values}
\usage{
plotCV(df)
}
\arguments{
\item{df}{\code{data.frame} containing one or multiple columns containing 
the coefficients of variation}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
The function \code{plotCV} displays the coefficient of variation values of 
set of values supplied in a \code{data.frame} object. The function will 
create a plot using the \code{ggplot2} package and will print the values 
in the different columns in different colors.
}
\details{
Internal usage in \code{shinyQC}.
}
\examples{
x1 <- matrix(seq_len(10), ncol = 2)
x2 <- matrix(seq(11, 20), ncol = 2)
x3 <- matrix(seq(21, 30), ncol = 2)
x4 <- matrix(seq(31, 40), ncol = 2)

## calculate cv values
cv1 <- cv(x1, "x1")
cv2 <- cv(x2, "x2")
cv3 <- cv(x3, "x3")
cv4 <- cv(x4, "x4")

df <- data.frame(cv1, cv2, cv3, cv4)
plotCV(df)

}
