% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{hoeffDValues}
\alias{hoeffDValues}
\title{Create values of Hoeffding's D statistics from M and A values}
\usage{
hoeffDValues(tbl, name = "raw", sample_n = NULL)
}
\arguments{
\item{tbl}{\code{tibble}, as obtained from the function \code{MAvalues}}

\item{name}{\code{character(1)}, name of the returned list}

\item{sample_n}{\code{numeric(1)}, number of features (subset) to be 
taken for calculation of Hoeffding's D values}
}
\value{
named list with Hoeffding's D values per sample
}
\description{
The function creates and returns Hoeffding's D statistics values 
from MA values. 

In case \code{sample_n} is set to a numerical value (e.g. 10000), a 
random subset containing \code{sample_n} is taken to calculate Hoeffding's D 
values to speed up the calculation. In case there are less features
than \code{sample_n}, all features are taken.
}
\details{
The function uses the function \code{hoeffd} from the \code{Hmisc} package to 
calculate the values.
}
\examples{
## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
set.seed(1)
a <- a + rnorm(100)
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

tbl <- MAvalues(se)
hoeffDValues(tbl, "raw")

## normalized values
se_n <- se
assay(se_n) <- normalizeAssay(a, "sum")
tbl_n <- MAvalues(se_n, group = "all")
hoeffDValues(tbl_n, "normalized")

## transformed values
se_t <- se
assay(se_t) <- transformAssay(a, "log")
tbl_t <- MAvalues(se_t, group = "all")
hoeffDValues(tbl_t, "transformed")

}
