% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{featurePlot}
\alias{featurePlot}
\title{Create a plot of (count/intensity) values over the samples}
\usage{
featurePlot(df)
}
\arguments{
\item{df}{\code{data.frame}}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
The function \code{featurePlot} creates a plot of (count/intensity) values 
for different data processing steps (referring to columns in the 
\code{data.frame}) over the different samples (referring to rows in 
the \code{data.frame}).
}
\details{
Internal usage in \code{shinyQC}.
}
\examples{
set.seed(1)
x1 <- matrix(rnorm(100), ncol = 10, nrow = 10, 
    dimnames = list(paste("feature", seq_len(10)), 
        paste("sample", seq_len(10))))
x2 <- x1 + 5
x3 <- x2 + 10
l <- list(x1 = x1, x2 = x2, x3 = x3)
df <- createDfFeature(l, "feature 1")
featurePlot(df)

}
