% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_dimensionreduction.R
\name{dimensionReductionPlot}
\alias{dimensionReductionPlot}
\title{Plot the coordinates from \code{dimensionReduction} values}
\usage{
dimensionReductionPlot(
  tbl,
  se,
  color = c("none", colnames(se@colData)),
  size = c("none", colnames(se@colData)),
  explainedVar = NULL,
  x_coord,
  y_coord,
  height = 600,
  interactive = TRUE
)
}
\arguments{
\item{tbl}{\code{tbl} as obtained by the function \code{dimensionReduction}}

\item{se}{\code{SummarizedExperiment}}

\item{color}{\code{character}, one of \code{"none"} or 
\code{colnames(se@colData)}}

\item{size}{\code{character}, one of \code{"none"} or 
\code{colnames(se@colData)}}

\item{explainedVar}{NULL or named \code{numeric}, if \code{numeric} 
\code{explainedVar} contains the explained variance per principal component 
(names of \code{explainedVar} corresponds to the principal components)}

\item{x_coord}{\code{character}, column name of \code{tbl} that stores 
x coordinates}

\item{y_coord}{\code{character}, column name of \code{tbl} that stores 
y coordinates}

\item{height}{\code{numeric}, specifying the height of the plot (in pixels)}

\item{interactive}{\code{logical(1)}, if \code{TRUE} 
\code{dimensionReductionPlot} will return a \code{plotly} object, 
if \code{FALSE} \code{dimensionReductionPlot} will return a \code{gg} object}
}
\value{
\code{plotly} or \code{gg}
}
\description{
The function \code{dimensionReductionPlot} creates a dimension reduction plot. 
The function takes as input the \code{tbl} object obtained 
from the \code{dimensionReduction} function. The \code{tbl} contains 
transformed values by one of the dimension reduction methods.
}
\details{
The function \code{dimensionReductionPlot} is a wrapper for a
\code{ggplot/ggplotly} expression.
}
\examples{
library(SummarizedExperiment)

## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, byrow = TRUE,
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
set.seed(1)
a <- a + rnorm(100)
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)),
  median_vals = apply(a, 2, median))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment(assay = a, rowData = rD, colData = cD)

pca <- dimensionReduction(x = assay(se), type = "PCA", params = list())[[1]]

dimensionReductionPlot(tbl = pca, se = se, color = "type", size = "median_vals",
    x_coord = "PC1", y_coord = "PC2")

}
\author{
Thomas Naake
}
