% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{batchCorrectionAssay}
\alias{batchCorrectionAssay}
\title{Remove batch effects from (count/intensity) values of a 
\code{SummarizedExperiment}}
\usage{
batchCorrectionAssay(
  se,
  method = c("none", "removeBatchEffect (limma)", "ComBat"),
  batch = NULL,
  batch2 = NULL,
  ...
)
}
\arguments{
\item{se}{\code{SummarizedExperiment}}

\item{method}{\code{character}, one of \code{"none"} or 
\code{"removeBatchEffect"}}

\item{batch}{\code{character}, \code{NULL} or one of 
\code{colnames(colData(se))}}

\item{batch2}{\code{character}, \code{NULL} or one of
\code{colnames(colData(se))}}

\item{...}{further arguments passed to \code{removeBatchEffect} or 
\code{ComBat}}
}
\value{
\code{matrix}
}
\description{
The function \code{batchCorrectionAssay} removes the batch effect of 
(count/intensity) values of a \code{SummarizedExperiment}. 
It uses either the \code{removeBatchEffect} or \code{ComBat} functions 
or no batch effect correction method (pass-through, 
\code{none}).
}
\details{
The column \code{batch} in \code{colData(se)} contains the information 
on the batch identity. For \code{method = "removeBatchEffect (limma)"},
\code{batch2} may indicate a second series of batches. 
Internal use in \code{shinyQC}.

If \code{batch} is NULL and \code{method} is set to 
\code{method = "removeBatchEffect (limma)"} or \code{method = "ComBat"},
no batch correction will be performed (equivalent to 
\code{method = "none"}).

The method \code{ComBat} will only perform batch correction on valid 
features: (1) more or equal than two observations (no \code{NA}) per level 
and per feature, (2) variance greater than 0 per feature, and (3) more than
two valid features as given by (1) and (2). For non-valid features, values
are taken from \code{assay(se)}.
}
\examples{
## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
    dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
set.seed(1)
a <- a + rnorm(100)
cD <- data.frame(name = colnames(a), 
    type = c(rep("1", 5), rep("2", 5)), batch = rep(c(1, 2), 5))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

## method = "removeBatchEffect (limma)"
batchCorrectionAssay(se, method = "removeBatchEffect (limma)", 
    batch = "batch", batch2 = NULL)

## method = "ComBat"
batchCorrectionAssay(se, method = "ComBat", 
    batch = "batch", batch2 = NULL)

}
