% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_summarization_prepare.R
\name{MSstatsPrepareForSummarization}
\alias{MSstatsPrepareForSummarization}
\title{Prepare feature-level data for protein-level summarization}
\usage{
MSstatsPrepareForSummarization(
  input,
  method,
  impute,
  censored_symbol,
  remove_uninformative_feature_outlier
)
}
\arguments{
\item{input}{feature-level data processed by dataProcess subfunctions}

\item{method}{summarization method - `summaryMethod` parameter of the dataProcess function}

\item{impute}{if TRUE, censored missing values will be imputed - `MBimpute`
parameter of the dataProcess function}

\item{censored_symbol}{censored missing value indicator - `censoredInt` 
parameter of the dataProcess function}

\item{remove_uninformative_feature_outlier}{if TRUE, features labeled as 
outlier of uninformative by the MSstatsSelectFeatures function will not be 
used in summarization}
}
\value{
data.table
}
\description{
Prepare feature-level data for protein-level summarization
}
\examples{
raw = DDARawData 
method = "TMP"
cens = "NA"
impute = TRUE
MSstatsConvert::MSstatsLogsSettings(FALSE)
input = MSstatsPrepareForDataProcess(raw, 2, NULL)
head(input)

}
