% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters_PDtoMSstatsFormat.R
\name{PDtoMSstatsFormat}
\alias{PDtoMSstatsFormat}
\title{Import Proteome Discoverer files}
\usage{
PDtoMSstatsFormat(
  input,
  annotation,
  useNumProteinsColumn = FALSE,
  useUniquePeptide = TRUE,
  summaryforMultipleRows = max,
  removeFewMeasurements = TRUE,
  removeOxidationMpeptides = FALSE,
  removeProtein_with1Peptide = FALSE,
  which.quantification = "Precursor.Area",
  which.proteinid = "Protein.Group.Accessions",
  which.sequence = "Sequence",
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  ...
)
}
\arguments{
\item{input}{PD report or a path to it.}

\item{annotation}{name of 'annotation.txt' or 'annotation.csv' data which includes Condition, BioReplicate,
Run information. 'Run' will be matched with 'Spectrum.File'.}

\item{useNumProteinsColumn}{TRUE removes peptides which have more than 1 in # Proteins column of PD output.}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned for more than one proteins.
We assume to use unique peptide for each protein.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple measurements for certain feature and certain run, use highest or sum of multiple intensities.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that have 1 or 2 measurements across runs.}

\item{removeOxidationMpeptides}{TRUE will remove the peptides including 'oxidation (M)' in modification. FALSE is default.}

\item{removeProtein_with1Peptide}{TRUE will remove the proteins which have only 1 peptide and charge. FALSE is default.}

\item{which.quantification}{Use 'Precursor.Area'(default) column for quantified intensities. 'Intensity' or 'Area' can be used instead.}

\item{which.proteinid}{Use 'Protein.Accessions'(default) column for protein name. 'Master.Protein.Accessions' can be used instead.}

\item{which.sequence}{Use 'Sequence'(default) column for peptide sequence. 'Annotated.Sequence' can be used instead.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{...}{additional parameters to \code{data.table::fread}.}
}
\value{
data.frame in the MSstats required format.
}
\description{
Import Proteome Discoverer files
}
\examples{

pd_raw = system.file("tinytest/raw_data/PD/pd_input.csv", 
                     package = "MSstatsConvert")
annot = system.file("tinytest/raw_data/PD/annot_pd.csv", 
                    package = "MSstatsConvert")
pd_raw = data.table::fread(pd_raw)
annot = data.table::fread(annot)

pd_imported = PDtoMSstatsFormat(pd_raw, annot, use_log_file = FALSE)
head(pd_imported)

}
\author{
Meena Choi, Olga Vitek
}
