% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters_MetamorpheusToMSstatsFormat.R
\name{MetamorpheusToMSstatsFormat}
\alias{MetamorpheusToMSstatsFormat}
\title{Import Metamorpheus files}
\usage{
MetamorpheusToMSstatsFormat(
  input,
  annotation = NULL,
  MBR = TRUE,
  qvalue_cutoff = 0.05,
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeProtein_with1Feature = FALSE,
  summaryforMultipleRows = max,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  ...
)
}
\arguments{
\item{input}{name of Metamorpheus output file, which is tabular format. Use the AllQuantifiedPeaks.tsv file from the Metamorpheus output.}

\item{annotation}{name of 'annotation.txt' data which includes Condition, BioReplicate.}

\item{MBR}{If TRUE, the function will include peaks detected by MBR}

\item{qvalue_cutoff}{The q-value cutoff for filtering peaks detected by MBR}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned for more than one proteins.
We assume to use unique peptide for each protein.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that have 1 or 2 measurements across runs.}

\item{removeProtein_with1Feature}{TRUE will remove the proteins which have only 1 feature, which is the combination of peptide, precursor charge, fragment and charge. FALSE is default.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple measurements for certain feature and certain run, use highest or sum of multiple intensities.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{...}{additional parameters to \code{data.table::fread}.}
}
\value{
data.frame in the MSstats required format.
}
\description{
Import Metamorpheus files
}
\examples{
input = system.file("tinytest/raw_data/Metamorpheus/QuantifiedPeaks.tsv", 
                                package = "MSstatsConvert")
input = data.table::fread(input)
annot = system.file("tinytest/raw_data/Metamorpheus/annotation.csv", 
                                package = "MSstatsConvert")
annot = data.table::fread(annot)
metamorpheus_imported = MSstatsConvert:::MetamorpheusToMSstatsFormat(input, annotation = annot)
head(metamorpheus_imported)

}
\author{
Anthony Wu
}
