% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata-selection.R
\name{selectFeatureData}
\alias{selectFeatureData}
\alias{requiredFvarLabels}
\title{Select feature variables of interest}
\usage{
selectFeatureData(object, graphics = TRUE, fcol)

requiredFvarLabels(x = c("OnDiskMSnExp", "MSnExp", "MSnSet"))
}
\arguments{
\item{object}{An \code{MSnSet}, \code{MSnExp} or \code{OnDiskMSnExp}.}

\item{graphics}{A \code{logical} (default is \code{TRUE})
indicating whether a shiny application should be used if
available. Otherwise, a text menu is used. Ignored if \code{k}
is not missing.}

\item{fcol}{A \code{numeric}, \code{logical} or \code{character} of
valid feature variables to be passed directly.}

\item{x}{\code{character(1)} specifying the class name for which the required
feature data variable names should be returned.}
}
\value{
For \code{selectFeatureData}: updated object containing only
selected feature variables.

For \code{requiredFvarLabels}: \code{character} with the required feature
variable names.
}
\description{
Select feature variables to be retained.

\code{requiredFvarLabels} returns a \code{character} vector with the
required feature data variable names (\code{fvarLabels}, i.e. the column
names in the \code{fData} \code{data.frame}) for the specified object.
}
\examples{

library("pRolocdata")
data(hyperLOPIT2015)
## 5 first feature variables
x <- selectFeatureData(hyperLOPIT2015, fcol = 1:5)
fvarLabels(x)
\dontrun{
## select via GUI
x <- selectFeatureData(hyperLOPIT2015)
fvarLabels(x)
}

## Subset the feature data of an OnDiskMSnExp object to the minimal
## required columns
f <- system.file("microtofq/MM14.mzML", package = "msdata")
od <- readMSData(f, mode = "onDisk")

## what columns do we have?
fvarLabels(od)

## Reduce the feature data data.frame to the required columns only
od <- selectFeatureData(od, fcol = requiredFvarLabels(class(od)))
fvarLabels(od)
}
\author{
Laurent Gatto
}
